/*
 * Decompiled with CFR 0.152.
 */
package workbench.ssh;

import workbench.util.StringUtil;

public class UrlParser {
    private static final String LOCAL_IP = "127.0.0.1";
    private final String originalUrl;
    private int dbPort = -1;
    private String dbHostname;

    public UrlParser(String string) {
        this.originalUrl = string;
        this.getLocalUrl(LOCAL_IP, 0);
    }

    public String getLocalUrl(int n) {
        return this.getLocalUrl(LOCAL_IP, n);
    }

    public boolean isLocalURL() {
        return this.isLocalhost(this.dbHostname);
    }

    public String getDatabaseServer() {
        return this.dbHostname;
    }

    public boolean isDefaultPort() {
        return this.dbPort < 0;
    }

    public int getDatabasePort() {
        if (this.dbPort < 0) {
            return this.getDefaultPort();
        }
        return this.dbPort;
    }

    private String getLocalUrl(String string, int n) {
        if (this.originalUrl == null) {
            return null;
        }
        String string2 = this.originalUrl.toLowerCase();
        if (string2.startsWith("jdbc:oracle:")) {
            if (string2.indexOf("@(description") > -1) {
                return this.rewriteOracleConnectionDescriptor(this.originalUrl, string, n);
            }
            if (string2.indexOf("@//") > -1) {
                return this.rewriteUrl(this.originalUrl, string, n, "@//", "/");
            }
            return this.rewriteOldOracle(this.originalUrl, string, n);
        }
        if (string2.startsWith("jdbc:jtds:sqlserver:")) {
            return this.rewriteUrl(this.originalUrl, string, n, "//", ";");
        }
        if (string2.startsWith("jdbc:sqlserver:")) {
            return this.rewriteUrl(this.originalUrl, string, n, "//", ";");
        }
        return this.rewriteUrl(this.originalUrl, string, n, "//", "/");
    }

    private String rewriteUrl(String string, String string2, int n, String string3, String string4) {
        String string5;
        String string6;
        int n2;
        int n3 = string.indexOf(string3);
        if (n3 < 0) {
            return string;
        }
        int n4 = string.indexOf(string4, n3 + string3.length());
        if (n4 < 0) {
            n4 = string.length();
        }
        if ((n2 = (string6 = string.substring(n3, n4)).indexOf(58)) > 0) {
            string5 = string6.substring(n2 + 1);
            this.dbHostname = string6.substring(string3.length(), n2);
            this.dbPort = StringUtil.getIntValue(string5, -1);
        } else {
            this.dbHostname = string6.substring(string3.length());
        }
        string5 = string.substring(0, n3 + string3.length());
        string5 = string5 + string2 + ":" + n;
        string5 = string5 + string.substring(n4);
        return string5;
    }

    private String rewriteOldOracle(String string, String string2, int n) {
        int n2;
        int n3 = string.indexOf(64);
        int n4 = n2 = string.indexOf(58, n3 + 1);
        if (n2 < 0) {
            return string;
        }
        this.dbHostname = string.substring(n3 + 1, n2);
        int n5 = string.indexOf(58, n2 + 1);
        if (n5 > -1) {
            n4 = n5;
            String string3 = string.substring(n2 + 1, n5);
            this.dbPort = StringUtil.getIntValue(string3, -1);
        }
        return string.substring(0, n3 + 1) + string2 + ":" + n + string.substring(n4);
    }

    private String rewriteOracleConnectionDescriptor(String string, String string2, int n) {
        return string;
    }

    private int getDefaultPort() {
        if (this.originalUrl == null) {
            return -1;
        }
        String string = this.originalUrl.toLowerCase();
        if (string.startsWith("jdbc:postgresql:")) {
            return 5432;
        }
        if (string.startsWith("jdbc:mysql:")) {
            return 3306;
        }
        if (string.startsWith("jdbc:oracle:")) {
            return 1521;
        }
        if (string.startsWith("jdbc:sqlserver:") || string.startsWith("jdbc:jtds:sqlserver:")) {
            return 1433;
        }
        return -1;
    }

    private boolean isLocalhost(String string) {
        if (string == null) {
            return false;
        }
        return "localhost".equalsIgnoreCase(string) || LOCAL_IP.equals(string);
    }
}

