/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.sql.Array;
import java.sql.SQLException;
import java.sql.Struct;
import workbench.storage.StructConverter;

public class ArrayConverter {
    private static final char[] DEFAULT_ARG_CHARACTERS = new char[]{'[', ']'};
    private static final char[] ORACLE_ARG_CHARACTERS = new char[]{'(', ')'};

    public static String getArrayDisplay(Object object, String string, boolean bl, boolean bl2) throws SQLException {
        if (object == null) {
            return null;
        }
        char[] cArray = bl2 ? ORACLE_ARG_CHARACTERS : DEFAULT_ARG_CHARACTERS;
        Object[] objectArray = null;
        String string2 = "";
        if (object instanceof Array) {
            Array array = (Array)object;
            objectArray = (Object[])array.getArray();
            string2 = string;
        } else if (object instanceof Object[]) {
            objectArray = (Object[])object;
        }
        if (objectArray != null) {
            int n = objectArray.length;
            StringBuilder stringBuilder = new StringBuilder(n * 10);
            if (bl) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(cArray[0]);
            StructConverter structConverter = StructConverter.getInstance();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(',');
                }
                if (objectArray[i] == null) {
                    stringBuilder.append("NULL");
                    continue;
                }
                if (objectArray[i] instanceof Struct) {
                    stringBuilder.append(structConverter.getStructDisplay((Struct)objectArray[i], bl2));
                    continue;
                }
                structConverter.appendValue(stringBuilder, objectArray[i]);
            }
            stringBuilder.append(cArray[1]);
            return stringBuilder.toString();
        }
        return object.toString();
    }
}

