/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import workbench.db.DbMetadata;
import workbench.db.DbSettings;
import workbench.storage.BlobLiteralFormatter;
import workbench.storage.BlobLiteralType;
import workbench.storage.DefaultBlobFormatter;
import workbench.storage.PostgresBlobFormatter;
import workbench.util.StringUtil;

public class BlobFormatterFactory {
    public static BlobLiteralFormatter createAnsiFormatter() {
        DefaultBlobFormatter defaultBlobFormatter = new DefaultBlobFormatter();
        defaultBlobFormatter.setPrefix("X'");
        defaultBlobFormatter.setSuffix("'");
        return defaultBlobFormatter;
    }

    public static BlobLiteralFormatter createInstance(BlobLiteralType blobLiteralType) {
        if (blobLiteralType == BlobLiteralType.pgDecode || blobLiteralType == BlobLiteralType.pgEscape || blobLiteralType == BlobLiteralType.pgHex) {
            return new PostgresBlobFormatter(blobLiteralType);
        }
        DefaultBlobFormatter defaultBlobFormatter = new DefaultBlobFormatter();
        defaultBlobFormatter.setLiteralType(blobLiteralType);
        return defaultBlobFormatter;
    }

    public static BlobLiteralFormatter createInstance(DbMetadata dbMetadata) {
        DbSettings dbSettings = dbMetadata.getDbSettings();
        String string = dbSettings.getBlobLiteralPrefix();
        String string2 = dbSettings.getBlobLiteralSuffix();
        if (StringUtil.isNonBlank(string) && StringUtil.isNonBlank(string2)) {
            DefaultBlobFormatter defaultBlobFormatter = new DefaultBlobFormatter();
            String string3 = dbSettings.getBlobLiteralType();
            BlobLiteralType blobLiteralType = null;
            try {
                blobLiteralType = BlobLiteralType.valueOf(string3);
            }
            catch (Throwable throwable) {
                blobLiteralType = BlobLiteralType.hex;
            }
            BlobLiteralType.valueOf(string3);
            defaultBlobFormatter.setUseUpperCase(dbSettings.getBlobLiteralUpperCase());
            defaultBlobFormatter.setLiteralType(blobLiteralType);
            defaultBlobFormatter.setPrefix(string);
            defaultBlobFormatter.setSuffix(string2);
            return defaultBlobFormatter;
        }
        if (dbMetadata.isPostgres()) {
            return new PostgresBlobFormatter();
        }
        if (dbMetadata.isOracle()) {
            DefaultBlobFormatter defaultBlobFormatter = new DefaultBlobFormatter();
            defaultBlobFormatter.setUseUpperCase(true);
            defaultBlobFormatter.setPrefix("'");
            defaultBlobFormatter.setSuffix("'");
            return defaultBlobFormatter;
        }
        if (dbMetadata.isSqlServer()) {
            DefaultBlobFormatter defaultBlobFormatter = new DefaultBlobFormatter();
            defaultBlobFormatter.setPrefix("0x");
            return defaultBlobFormatter;
        }
        return BlobFormatterFactory.createAnsiFormatter();
    }
}

