/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import workbench.gui.editor.SearchAndReplace;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.storage.Position;
import workbench.util.ConverterException;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class DataStoreReplacer {
    private DataStore client;
    private Position lastFoundPosition;
    private Pattern lastPattern;
    private String currentReplacementValue;
    private int[] selectedRows;
    private int lastSelectedRowIndex;
    private String lastCriteria;
    private boolean isRegexSearch;

    public DataStoreReplacer() {
    }

    public DataStoreReplacer(DataStore dataStore) {
        this.setDataStore(dataStore);
    }

    public final void setDataStore(DataStore dataStore) {
        this.client = dataStore;
        this.reset();
    }

    public void setSelectedRows(int[] nArray) {
        this.selectedRows = nArray;
        this.lastSelectedRowIndex = 0;
    }

    public Position getLastFoundPosition() {
        return this.lastFoundPosition;
    }

    public String getLastCriteria() {
        return this.lastCriteria;
    }

    public Position find(String string, boolean bl, boolean bl2, boolean bl3) throws PatternSyntaxException {
        this.lastCriteria = string;
        this.lastFoundPosition = Position.NO_POSITION;
        this.lastSelectedRowIndex = 0;
        if (StringUtil.isEmptyString(string)) {
            return Position.NO_POSITION;
        }
        this.isRegexSearch = bl3;
        String string2 = SearchAndReplace.getSearchExpression(string, bl, bl2, bl3);
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(string2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            LogMgr.logError(new CallerInfo(){}, "Error compiling search pattern", patternSyntaxException);
            throw patternSyntaxException;
        }
        return this.findPattern(pattern);
    }

    public Position findNext() {
        if (this.lastPattern == null) {
            this.reset();
            return this.lastFoundPosition;
        }
        return this.findPattern(this.lastPattern);
    }

    public void reset() {
        this.lastPattern = null;
        this.lastCriteria = null;
        this.currentReplacementValue = null;
        this.lastSelectedRowIndex = 0;
        this.lastFoundPosition = Position.NO_POSITION;
    }

    private Position findPattern(Pattern pattern) {
        int n = 0;
        int n2 = 0;
        int n3 = this.client.getRowCount();
        int n4 = this.client.getColumnCount();
        if (this.lastFoundPosition.isValid()) {
            n = this.lastFoundPosition.getRow();
            n2 = this.lastFoundPosition.getColumn() + 1;
            if (n2 >= n4) {
                n2 = 0;
                ++n;
            }
        }
        this.lastPattern = pattern;
        int n5 = n;
        if (this.selectedRows != null) {
            n5 = this.lastSelectedRowIndex;
            n3 = this.selectedRows.length;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        for (int i = n5; i < n3; ++i) {
            int n6 = i;
            if (this.selectedRows != null) {
                this.lastSelectedRowIndex = i;
                n6 = this.selectedRows[i];
            }
            for (int j = n2; j < n4; ++j) {
                Matcher matcher;
                String string;
                int n7 = this.client.getColumnType(j);
                if (SqlUtil.isBlobType(n7) || StringUtil.isEmptyString(string = this.client.getValueAsString(n6, j)) || !(matcher = pattern.matcher(string)).find()) continue;
                this.lastFoundPosition = new Position(n6, j);
                return this.lastFoundPosition;
            }
            n2 = 0;
        }
        return Position.NO_POSITION;
    }

    public int replaceAll(String string, String string2, int[] nArray, boolean bl, boolean bl2, boolean bl3) throws ConverterException, PatternSyntaxException {
        this.reset();
        String string3 = SearchAndReplace.getSearchExpression(string, bl, bl2, bl3);
        this.isRegexSearch = bl3;
        this.currentReplacementValue = SearchAndReplace.fixSpecialReplacementChars(string2, this.isRegexSearch);
        int n = 0;
        Pattern pattern = Pattern.compile(string3);
        this.setSelectedRows(nArray);
        Position position = this.findPattern(pattern);
        while (position.isValid()) {
            this.replaceValueAt(position, this.currentReplacementValue, this.lastPattern);
            ++n;
            position = this.findNext();
        }
        return n;
    }

    public boolean replaceCurrent(String string) throws ConverterException {
        if (this.lastFoundPosition == null) {
            return false;
        }
        if (this.lastFoundPosition.isValid()) {
            this.currentReplacementValue = SearchAndReplace.fixSpecialReplacementChars(string, this.isRegexSearch);
            this.replaceValueAt(this.lastFoundPosition, this.currentReplacementValue, this.lastPattern);
            return true;
        }
        return false;
    }

    private void replaceValueAt(Position position, String string, Pattern pattern) throws ConverterException {
        String string2 = this.client.getValueAsString(position.getRow(), position.getColumn());
        if (!StringUtil.isEmptyString(string2)) {
            Matcher matcher = pattern.matcher(string2);
            String string3 = matcher.replaceAll(string);
            try {
                this.client.setInputValue(position.getRow(), position.getColumn(), string3);
            }
            catch (ConverterException converterException) {
                LogMgr.logError(new CallerInfo(){}, "Could not convert the replacement data", converterException);
                throw converterException;
            }
        }
    }
}

