/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import workbench.db.AnsiSQLMergeGenerator;
import workbench.db.DBID;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.db.firebird.Firebird20MergeGenerator;
import workbench.db.firebird.Firebird21MergeGenerator;
import workbench.db.h2database.H2MergeGenerator;
import workbench.db.hsqldb.HsqlMergeGenerator;
import workbench.db.ibm.Db2MergeGenerator;
import workbench.db.mssql.SqlServerMergeGenerator;
import workbench.db.mysql.MySQLMergeGenerator;
import workbench.db.oracle.OracleMergeGenerator;
import workbench.db.postgres.Postgres95MergeGenerator;
import workbench.db.postgres.PostgresWriteableCTEGenerator;
import workbench.resource.Settings;
import workbench.storage.ResultInfo;
import workbench.storage.RowData;
import workbench.storage.RowDataContainer;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.CollectionUtil;

public interface MergeGenerator {
    public static final String PG_CTE_TYPE = "postgres-cte";

    public String generateMerge(RowDataContainer var1);

    public String generateMergeStart(RowDataContainer var1);

    public String addRow(ResultInfo var1, RowData var2, long var3);

    public String generateMergeEnd(RowDataContainer var1);

    public static class Factory {
        private static final Map<String, String> DBID_TO_TYPE_MAP = new TreeMap<String, String>(CaseInsensitiveComparator.INSTANCE);

        public static MergeGenerator createGenerator(WbConnection wbConnection) {
            if (wbConnection == null) {
                return new AnsiSQLMergeGenerator();
            }
            if (wbConnection.getMetadata().isPostgres() && JdbcUtils.hasMinimumServerVersion(wbConnection, "9.5")) {
                return new Postgres95MergeGenerator();
            }
            return Factory.createGenerator(wbConnection.getDbId());
        }

        public static MergeGenerator createGenerator(String string) {
            if (string == null) {
                return null;
            }
            if (DBID.Oracle.isDB(string = string.toLowerCase())) {
                return new OracleMergeGenerator();
            }
            if (DBID.Postgres.isDB(string) || string.equals("postgres")) {
                return new Postgres95MergeGenerator();
            }
            if (string.equals(MergeGenerator.PG_CTE_TYPE)) {
                return new PostgresWriteableCTEGenerator();
            }
            if (DBID.MySQL.isDB(string) || DBID.MariaDB.isDB(string)) {
                return new MySQLMergeGenerator();
            }
            if (DBID.SQL_Server.isDB(string) || "sqlserver".equals(string)) {
                return new SqlServerMergeGenerator(string);
            }
            if (string.startsWith("hsql")) {
                return new HsqlMergeGenerator();
            }
            if (string.startsWith("db2")) {
                return new Db2MergeGenerator();
            }
            if (string.startsWith("h2")) {
                return new H2MergeGenerator();
            }
            if (DBID.Firebird.isDB(string)) {
                if (Settings.getInstance().getBoolProperty("workbench.db.firebird.mergegenerator.use.ansi", true)) {
                    return new Firebird21MergeGenerator();
                }
                return new Firebird20MergeGenerator();
            }
            return new AnsiSQLMergeGenerator();
        }

        public static List<String> getSupportedTypes() {
            return CollectionUtil.arrayList("ansi", "db2", DBID.Firebird.getId(), DBID.H2.getId(), "hsqldb", DBID.MariaDB.getId(), DBID.MySQL.getId(), DBID.Oracle.getId(), "postgres", MergeGenerator.PG_CTE_TYPE, "sqlserver");
        }

        public static String getTypeForDBID(String string) {
            if (string == null) {
                return "ansi";
            }
            String string2 = DBID_TO_TYPE_MAP.get(string);
            if (string2 == null) {
                return "ansi";
            }
            return string2;
        }

        static {
            DBID_TO_TYPE_MAP.put("postgresql", "postgres");
            DBID_TO_TYPE_MAP.put("h2database", "h2");
            DBID_TO_TYPE_MAP.put("microsoft_sql_server", "sqlserver");
            DBID_TO_TYPE_MAP.put("db2i", "db2");
            DBID_TO_TYPE_MAP.put("db2h", "db2");
            DBID_TO_TYPE_MAP.put("hsql_database_engine", "hsqldb");
        }
    }
}

