/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.storage.DataStore;
import workbench.storage.ResultInfo;
import workbench.util.Alias;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.CollectionUtil;
import workbench.util.SelectColumn;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class ResultColumnMetaData {
    private List<Alias> tables;
    private List<String> queryColumns;
    private WbConnection connection;

    public ResultColumnMetaData(WbConnection wbConnection) {
        this.connection = wbConnection;
    }

    public ResultColumnMetaData(DataStore dataStore) {
        this(dataStore.getGeneratingSql(), dataStore.getOriginalConnection());
    }

    public ResultColumnMetaData(String string, WbConnection wbConnection) {
        this.connection = wbConnection;
        if (StringUtil.isBlank(string)) {
            return;
        }
        this.tables = SqlUtil.getTables(string, true, wbConnection);
        this.queryColumns = SqlUtil.getSelectColumns(string, true, wbConnection);
    }

    public void retrieveColumnRemarks(ResultInfo resultInfo) throws SQLException {
        DbMetadata dbMetadata = this.connection.getMetadata();
        TreeMap<String, TableDefinition> treeMap = new TreeMap<String, TableDefinition>(CaseInsensitiveComparator.INSTANCE);
        for (Alias alias : this.tables) {
            if (StringUtil.isBlank(alias.getNameToUse())) continue;
            TableIdentifier tableIdentifier = new TableIdentifier(alias.getObjectName(), this.connection);
            TableDefinition tableDefinition = dbMetadata.getTableDefinition(tableIdentifier);
            treeMap.put(alias.getNameToUse().toLowerCase(), tableDefinition);
        }
        this.updateFromQueryColumns(resultInfo, treeMap);
    }

    private void updateFromQueryColumns(ResultInfo resultInfo, Map<String, TableDefinition> map) {
        if (CollectionUtil.isEmpty(this.queryColumns)) {
            return;
        }
        List<SelectColumn> list = this.expandQueryColumns(map);
        for (SelectColumn selectColumn : list) {
            TableDefinition tableDefinition = this.findTableForColumn(selectColumn, map);
            if (tableDefinition == null) continue;
            ColumnIdentifier columnIdentifier = tableDefinition.findColumn(selectColumn.getObjectName());
            ColumnIdentifier columnIdentifier2 = this.findResultColumn(resultInfo, selectColumn);
            if (columnIdentifier2 == null) continue;
            columnIdentifier2.setComment(columnIdentifier.getComment());
            columnIdentifier2.setSourceTableName(tableDefinition.getTable().getRawTableName());
        }
    }

    private ColumnIdentifier findResultColumn(ResultInfo resultInfo, SelectColumn selectColumn) {
        ColumnIdentifier columnIdentifier;
        DbMetadata dbMetadata = this.connection.getMetadata();
        String string = dbMetadata.removeQuotes(selectColumn.getObjectName());
        String string2 = dbMetadata.removeQuotes(selectColumn.getAlias());
        String string3 = dbMetadata.removeQuotes(selectColumn.getNameToUse());
        String string4 = dbMetadata.removeQuotes(selectColumn.getColumnTable());
        if (string4 != null && string3 != null && this.connection.getDbSettings().supportsResultMetaGetTable() && (columnIdentifier = this.findByTableAndColumn(resultInfo, string, string4)) != null) {
            return columnIdentifier;
        }
        int n = selectColumn.getIndexInResult();
        if (n > -1 && n < resultInfo.getColumnCount()) {
            return resultInfo.getColumn(n);
        }
        for (ColumnIdentifier columnIdentifier2 : resultInfo.getColumns()) {
            String string5 = dbMetadata.removeQuotes(columnIdentifier2.getColumnName());
            String string6 = dbMetadata.removeQuotes(columnIdentifier2.getColumnAlias());
            if (string2 != null && string6 != null && string2.equalsIgnoreCase(string6)) {
                return columnIdentifier2;
            }
            if (string != null && string5 != null && string.equalsIgnoreCase(string5)) {
                return columnIdentifier2;
            }
            if (string3 == null || !string3.equalsIgnoreCase(string5)) continue;
            return columnIdentifier2;
        }
        return null;
    }

    private ColumnIdentifier findByTableAndColumn(ResultInfo resultInfo, String string, String string2) {
        DbMetadata dbMetadata = this.connection.getMetadata();
        for (ColumnIdentifier columnIdentifier : resultInfo.getColumns()) {
            String string3 = dbMetadata.removeQuotes(columnIdentifier.getColumnName());
            String string4 = dbMetadata.removeQuotes(columnIdentifier.getSourceTableName());
            if (!StringUtil.equalStringIgnoreCase(string4, string2) || !StringUtil.equalStringIgnoreCase(string3, string)) continue;
            return columnIdentifier;
        }
        return null;
    }

    private List<SelectColumn> expandQueryColumns(Map<String, TableDefinition> map) {
        ArrayList<SelectColumn> arrayList = new ArrayList<SelectColumn>();
        if (this.queryColumns.size() == 1 && this.queryColumns.get(0).equals("*")) {
            int n = 0;
            for (Alias alias : this.tables) {
                TableDefinition tableDefinition = map.get(alias.getNameToUse());
                if (tableDefinition == null) continue;
                for (ColumnIdentifier columnIdentifier : tableDefinition.getColumns()) {
                    SelectColumn selectColumn = new SelectColumn(columnIdentifier.getColumnName());
                    selectColumn.setColumnTable(tableDefinition.getTable().getRawTableName());
                    selectColumn.setIndexInResult(n++);
                    arrayList.add(selectColumn);
                }
            }
            return arrayList;
        }
        int n = 0;
        for (String string : this.queryColumns) {
            SelectColumn selectColumn = new SelectColumn(string);
            String string2 = selectColumn.getColumnTable();
            if (StringUtil.isBlank(string2)) {
                selectColumn.setIndexInResult(n++);
                arrayList.add(selectColumn);
                continue;
            }
            TableDefinition tableDefinition = map.get(selectColumn.getColumnTable());
            if (tableDefinition == null) continue;
            if (selectColumn.getObjectName().equals("*")) {
                for (ColumnIdentifier columnIdentifier : tableDefinition.getColumns()) {
                    SelectColumn selectColumn2 = new SelectColumn(columnIdentifier.getColumnName());
                    selectColumn2.setColumnTable(tableDefinition.getTable().getRawTableName());
                    selectColumn2.setIndexInResult(n++);
                    arrayList.add(selectColumn2);
                }
                continue;
            }
            selectColumn.setColumnTable(string2);
            selectColumn.setIndexInResult(n++);
            arrayList.add(selectColumn);
        }
        return arrayList;
    }

    private String getTableNameForAlias(String string) {
        if (StringUtil.isEmptyString(string)) {
            return null;
        }
        for (Alias alias : this.tables) {
            if (!StringUtil.equalStringOrEmpty(alias.getAlias(), string)) continue;
            return alias.getObjectName();
        }
        return string;
    }

    private TableDefinition findTableForColumn(SelectColumn selectColumn, Map<String, TableDefinition> map) {
        for (TableDefinition tableDefinition : map.values()) {
            ColumnIdentifier columnIdentifier;
            String string = this.getTableNameForAlias(this.connection.getMetadata().removeQuotes(selectColumn.getColumnTable()));
            if (string != null && !StringUtil.equalStringIgnoreCase(string, tableDefinition.getTable().getRawTableName()) || (columnIdentifier = ColumnIdentifier.findColumnInList(tableDefinition.getColumns(), selectColumn.getObjectName())) == null) continue;
            return tableDefinition;
        }
        return null;
    }

    public void updateCommentsFromDefinition(DataStore dataStore, TableDefinition tableDefinition) {
        if (dataStore == null) {
            return;
        }
        ResultInfo resultInfo = dataStore.getResultInfo();
        if (resultInfo == null) {
            return;
        }
        String string = tableDefinition.getTable().getRawTableName();
        for (ColumnIdentifier columnIdentifier : tableDefinition.getColumns()) {
            int n = resultInfo.findColumn(columnIdentifier.getColumnName(), this.connection.getMetadata());
            if (n <= -1) continue;
            ColumnIdentifier columnIdentifier2 = resultInfo.getColumn(n);
            columnIdentifier2.setComment(columnIdentifier.getComment());
            if (columnIdentifier2.getSourceTableName() != null) continue;
            columnIdentifier2.setSourceTableName(string);
        }
    }
}

