/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.storage.DataStore;
import workbench.storage.ResultInfo;
import workbench.storage.RowData;
import workbench.storage.SelectionRowDataContainer;
import workbench.storage.SingleRowDataContainer;

public interface RowDataContainer {
    public int getRowCount();

    public RowData getRow(int var1);

    public ResultInfo getResultInfo();

    public TableIdentifier getUpdateTable();

    public WbConnection getOriginalConnection();

    public static class Factory {
        public static RowDataContainer createContainer(DataStore dataStore) {
            return dataStore;
        }

        public static RowDataContainer createContainer(WbConnection wbConnection, RowData rowData, ResultInfo resultInfo) {
            return new SingleRowDataContainer(wbConnection, rowData, resultInfo);
        }

        public static RowDataContainer createContainer(DataStore dataStore, int n) {
            return new SingleRowDataContainer(dataStore.getOriginalConnection(), dataStore.getRow(n), dataStore.getResultInfo());
        }

        public static RowDataContainer createContainer(DataStore dataStore, int[] nArray) {
            return new SelectionRowDataContainer(dataStore, nArray);
        }
    }
}

