/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.sql.Array;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.RowData;
import workbench.storage.RowDataList;
import workbench.storage.SortDefinition;
import workbench.util.StringUtil;

public class RowDataListSorter
implements Comparator<RowData> {
    private SortDefinition definition;
    private Collator defaultCollator;
    private boolean ignoreCase;
    private boolean naturalSort;

    public RowDataListSorter(SortDefinition sortDefinition) {
        this.definition = sortDefinition.createCopy();
        this.ignoreCase = sortDefinition.getIgnoreCase();
        this.initCollator();
    }

    public RowDataListSorter(int n, boolean bl) {
        this.definition = new SortDefinition(n, bl);
        this.initCollator();
    }

    public RowDataListSorter(int[] nArray, boolean[] blArray) {
        if (nArray.length != blArray.length) {
            throw new IllegalArgumentException("Size of arrays must match");
        }
        this.definition = new SortDefinition(nArray, blArray);
        this.initCollator();
    }

    public void setUseNaturalSort(boolean bl) {
        this.naturalSort = bl;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    private void initCollator() {
        Locale locale = Settings.getInstance().getSortLocale();
        this.defaultCollator = locale != null ? Collator.getInstance(locale) : null;
    }

    public void sort(RowDataList rowDataList) {
        rowDataList.sort(this);
    }

    protected int compareColumn(int n, RowData rowData, RowData rowData2) {
        Object object = rowData.getValue(n);
        Object object2 = rowData2.getValue(n);
        return this.compareValues(object, object2);
    }

    protected int compareValues(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return 1;
        }
        if (object2 == null) {
            return -1;
        }
        if (object instanceof String && object2 instanceof String) {
            if (this.defaultCollator != null) {
                return this.defaultCollator.compare(object, object2);
            }
            if (this.naturalSort) {
                return StringUtil.naturalCompare((String)object, (String)object2, this.ignoreCase);
            }
            return StringUtil.compareStrings((String)object, (String)object2, this.ignoreCase);
        }
        int n = 0;
        try {
            if (object instanceof Comparable && object2 instanceof Comparable) {
                n = ((Comparable)object).compareTo(object2);
            } else if (object instanceof Array && object2 instanceof Array) {
                n = this.compareArrays((Array)object, (Array)object2);
            } else {
                String string = object.toString();
                String string2 = object2.toString();
                n = string.compareTo(string2);
            }
        }
        catch (Throwable throwable) {
            String string = object.toString();
            String string3 = object2.toString();
            n = string.compareTo(string3);
        }
        return n;
    }

    private int compareArrays(Array array, Array array2) throws Exception {
        Object[] objectArray = (Object[])array.getArray();
        Object[] objectArray2 = (Object[])array2.getArray();
        int n = objectArray.length;
        int n2 = objectArray2.length;
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            Object object = objectArray[i];
            Object object2 = objectArray2[i];
            int n4 = this.compareValues(object, object2);
            if (n4 == 0) continue;
            return n4;
        }
        return n - n2;
    }

    @Override
    public int compare(RowData rowData, RowData rowData2) {
        if (this.definition == null) {
            return 0;
        }
        try {
            int n;
            int n2 = 0;
            int n3 = this.definition.getColumnCount();
            for (int i = 0; n2 == 0 && i < n3 && (n = this.definition.getSortColumnByIndex(i)) >= 0; ++i) {
                n2 = this.compareColumn(n, rowData, rowData2);
                boolean bl = this.definition.isSortAscending(n);
                n2 = bl ? n2 : -n2;
            }
            return n2;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when comparing rows", exception);
            return 0;
        }
    }
}

