/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.ResultInfo;
import workbench.util.Alias;
import workbench.util.SelectColumn;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class SourceTableDetector {
    public List<String> getColumnsFromTable(TableIdentifier tableIdentifier, String string, WbConnection wbConnection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (tableIdentifier == null) {
            return arrayList;
        }
        if (StringUtil.isBlank(string)) {
            return arrayList;
        }
        List<Alias> list = SqlUtil.getTables(string, true, wbConnection);
        List<SelectColumn> list2 = this.getColumns(string, wbConnection);
        for (SelectColumn selectColumn : list2) {
            String string2;
            String string3 = selectColumn.getColumnTable();
            if (string3 == null || !TableIdentifier.compareNames(tableIdentifier, new TableIdentifier(string2 = this.findTableFromAlias(string3, list)), true)) continue;
            arrayList.add(selectColumn.getObjectName());
        }
        return arrayList;
    }

    public void checkColumnTables(String string, ResultInfo resultInfo, WbConnection wbConnection) {
        this.resetResult(resultInfo);
        List<Alias> list = SqlUtil.getTables(string, true, wbConnection);
        List<SelectColumn> list2 = this.getColumns(string, wbConnection);
        if (list.size() == 1) {
            for (ColumnIdentifier columnIdentifier : resultInfo.getColumns()) {
                columnIdentifier.setSourceTableName(list.get(0).getObjectName());
            }
            resultInfo.setColumnTableDetected(true);
            return;
        }
        if (list2.size() != resultInfo.getColumnCount()) {
            LogMgr.logWarning(new CallerInfo(){}, "The SQL statement contains a different number of columns than the ResultInfo");
            return;
        }
        int n = 0;
        for (int i = 0; i < list2.size(); ++i) {
            SelectColumn selectColumn = list2.get(i);
            String string2 = selectColumn.getColumnTable();
            if (string2 == null) {
                LogMgr.logDebug(new CallerInfo(){}, "Column " + selectColumn + " is unqalified. Cannot determine the table it belongs to.");
                continue;
            }
            String string3 = this.findTableFromAlias(string2, list);
            if (string3 == null) continue;
            LogMgr.logDebug(new CallerInfo(){}, "Column " + selectColumn.toString() + " seems to belong to table " + string3);
            resultInfo.getColumn(i).setSourceTableName(string3);
            ++n;
        }
        resultInfo.setColumnTableDetected(n == list2.size());
    }

    private String findTableFromAlias(String string, List<Alias> list) {
        for (Alias alias : list) {
            TableIdentifier tableIdentifier;
            TableIdentifier tableIdentifier2;
            if (alias.getNameToUse().equalsIgnoreCase(string)) {
                return alias.getObjectName();
            }
            if (alias.getAlias() != null || !(tableIdentifier2 = new TableIdentifier(alias.getObjectName())).compareNames(tableIdentifier = new TableIdentifier(string))) continue;
            return alias.getObjectName();
        }
        return null;
    }

    private void resetResult(ResultInfo resultInfo) {
        for (ColumnIdentifier columnIdentifier : resultInfo.getColumns()) {
            columnIdentifier.setSourceTableName(null);
        }
        resultInfo.setColumnTableDetected(false);
    }

    private List<SelectColumn> getColumns(String string, WbConnection wbConnection) {
        List<String> list = SqlUtil.getSelectColumns(string, true, wbConnection);
        ArrayList<SelectColumn> arrayList = new ArrayList<SelectColumn>(list.size());
        for (String string2 : list) {
            arrayList.add(new SelectColumn(string2));
        }
        return arrayList;
    }
}

