/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.io.File;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.TreeMap;
import workbench.db.DBID;
import workbench.db.DbSettings;
import workbench.db.WbConnection;
import workbench.db.exporter.InfinityLiterals;
import workbench.db.postgres.HstoreSupport;
import workbench.interfaces.DataFileWriter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.BlobFormatterFactory;
import workbench.storage.BlobLiteralFormatter;
import workbench.storage.BlobLiteralType;
import workbench.storage.ColumnData;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbDateFormatter;

public class SqlLiteralFormatter {
    public static final String JDBC_DATE_LITERAL_TYPE = "jdbc";
    public static final String ANSI_DATE_LITERAL_TYPE = "ansi";
    public static final String STANDARD_DATE_LITERAL_TYPE = "default";
    public static final String DBMS_DATE_LITERAL_TYPE = "dbms";
    private WbDateFormatter dateFormatter;
    private WbDateFormatter timestampFormatter;
    private WbDateFormatter timestampTZFormatter;
    private WbDateFormatter timeFormatter;
    private BlobLiteralFormatter blobFormatter;
    private DataFileWriter blobWriter;
    private DataFileWriter clobWriter;
    private boolean treatClobAsFile = false;
    private int clobFileThreshold = -1;
    private String clobEncoding = Settings.getInstance().getDefaultFileEncoding();
    private boolean isDbId;
    private boolean isOracle;
    private DbSettings dbSettings;
    private boolean checkDBMSTypes;
    private final Map<String, WbDateFormatter> dbmsFormatters = new TreeMap<String, WbDateFormatter>(CaseInsensitiveComparator.INSTANCE);

    public SqlLiteralFormatter() {
        this((String)null);
    }

    public SqlLiteralFormatter(WbConnection wbConnection) {
        String string = null;
        this.isDbId = false;
        if (wbConnection != null && wbConnection.getMetadata() != null) {
            string = wbConnection.getMetadata().getDbId();
            this.isDbId = true;
            this.dbSettings = wbConnection.getDbSettings();
            this.isOracle = wbConnection.getMetadata().isOracle();
        }
        this.setDateLiteralType(string);
        this.checkDBMSTypes = true;
    }

    public SqlLiteralFormatter(String string) {
        this.isDbId = true;
        this.isOracle = DBID.Oracle.isDB(string);
        this.setDateLiteralType(string);
        this.checkDBMSTypes = true;
    }

    public void setProduct(WbConnection wbConnection) {
        if (wbConnection != null) {
            String string = wbConnection.getMetadata().getDbId();
            this.isDbId = true;
            this.isOracle = wbConnection.getMetadata().isOracle();
            this.dbSettings = wbConnection.getDbSettings();
            this.setDateLiteralType(string);
        }
        this.checkDBMSTypes = true;
    }

    public final void setDateLiteralType(String string) {
        this.checkDBMSTypes = false;
        this.dbmsFormatters.clear();
        if (DBMS_DATE_LITERAL_TYPE.equalsIgnoreCase(string)) {
            if (this.isDbId) {
                return;
            }
            string = null;
        }
        this.dateFormatter = SqlLiteralFormatter.createFormatter(string, "date", "''yyyy-MM-dd''");
        this.timestampFormatter = SqlLiteralFormatter.createFormatter(string, "timestamp", "''yyyy-MM-dd HH:mm:ss''");
        this.timestampTZFormatter = SqlLiteralFormatter.createFormatter(string, "timestamptz", "''yyyy-MM-dd HH:mm:ss[ Z]''");
        this.timeFormatter = SqlLiteralFormatter.createFormatter(string, "time", "''HH:mm:ss''");
    }

    public void setInfinityLiterals(InfinityLiterals infinityLiterals) {
        this.dateFormatter.setInfinityLiterals(infinityLiterals);
        this.timestampFormatter.setInfinityLiterals(infinityLiterals);
    }

    public void noBlobHandling() {
        this.blobWriter = null;
        this.blobFormatter = null;
    }

    public void setBlobFormat(BlobLiteralType blobLiteralType) {
        this.blobWriter = null;
        this.blobFormatter = BlobFormatterFactory.createInstance(blobLiteralType);
    }

    public void createAnsiBlobLiterals() {
        this.blobFormatter = BlobFormatterFactory.createAnsiFormatter();
        this.blobWriter = null;
    }

    public void createDbmsBlobLiterals(WbConnection wbConnection) {
        if (wbConnection != null) {
            this.blobFormatter = BlobFormatterFactory.createInstance(wbConnection.getMetadata());
            this.blobWriter = null;
        }
    }

    public void createBlobFiles(DataFileWriter dataFileWriter) {
        this.blobFormatter = null;
        this.blobWriter = dataFileWriter;
    }

    public void setTreatClobAsFile(DataFileWriter dataFileWriter, String string) {
        this.setTreatClobAsFile(dataFileWriter, string, -1);
    }

    public void setTreatClobAsFile(DataFileWriter dataFileWriter, String string, int n) {
        this.treatClobAsFile = true;
        this.clobFileThreshold = n;
        this.clobWriter = dataFileWriter;
        if (!StringUtil.isEmptyString(string)) {
            this.clobEncoding = string;
        }
    }

    private static String getPattern(String string, String string2) {
        String string3 = "workbench.sql.literals." + (string == null ? STANDARD_DATE_LITERAL_TYPE : string) + "." + string2 + ".pattern";
        String string4 = Settings.getInstance().getProperty(string3, null);
        if (string4 != null && string4.startsWith("${") && string4.endsWith("}")) {
            string = string4.substring(2, string4.length() - 1);
            string3 = "workbench.sql.literals." + string + "." + string2 + ".pattern";
            string4 = Settings.getInstance().getProperty(string3, null);
        }
        return string4;
    }

    public static WbDateFormatter createFormatter(String string, String string2, String string3) {
        WbDateFormatter wbDateFormatter = null;
        String string4 = SqlLiteralFormatter.getPattern(string, string2);
        try {
            if (string4 == null) {
                String string5 = "workbench.sql.literals.default." + string2 + ".pattern";
                string4 = Settings.getInstance().getProperty(string5, string3);
            }
            wbDateFormatter = new WbDateFormatter(string4);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not create formatter with pattern [" + string4 + "], using default [" + string3 + "]", exception);
            wbDateFormatter = new WbDateFormatter(string3);
        }
        return wbDateFormatter;
    }

    private String quoteString(int n, String string) {
        if (string == null) {
            return string;
        }
        String string2 = n == -9 || n == -15 || n == 2011 || n == -16 ? "N'" : "'";
        return string2 + string.replace("'", "''") + "'";
    }

    public CharSequence getDefaultLiteral(ColumnData columnData) {
        Object object = columnData.getValue();
        if (object == null) {
            return "NULL";
        }
        int n = columnData.getIdentifier().getDataType();
        String string = columnData.getIdentifier().getDbmsType();
        if (n == Integer.MIN_VALUE) {
            return object.toString();
        }
        String string2 = this.formatDbmsType(columnData);
        if (string2 != null) {
            return string2;
        }
        if (n == 2002) {
            return object.toString();
        }
        if (object instanceof String) {
            String string3 = (String)object;
            if (this.treatClobAsFile && string3.length() > this.clobFileThreshold && this.clobWriter != null && SqlUtil.isClobType(n, string, this.dbSettings)) {
                try {
                    File file = this.clobWriter.generateDataFileName(columnData);
                    this.clobWriter.writeClobFile(string3, file, this.clobEncoding);
                    return "{$clobfile='" + file.getName() + "' encoding='" + this.clobEncoding + "'}";
                }
                catch (Exception exception) {
                    LogMgr.logError(new CallerInfo(){}, "Could not write CLOB file", exception);
                    return this.quoteString(n, string3);
                }
            }
            return this.quoteString(n, string3);
        }
        if (object instanceof Time) {
            return this.timeFormatter.formatTime((Time)object);
        }
        if (object instanceof ZonedDateTime) {
            return this.fixInfinity(this.timestampTZFormatter.formatTimestamp((ZonedDateTime)object));
        }
        if (object instanceof OffsetDateTime) {
            return this.fixInfinity(this.timestampTZFormatter.formatTimestamp((OffsetDateTime)object));
        }
        if (object instanceof LocalDateTime) {
            return this.fixInfinity(this.timestampFormatter.formatTimestamp((LocalDateTime)object));
        }
        if (object instanceof Timestamp) {
            return this.fixInfinity(this.timestampFormatter.formatTimestamp((Timestamp)object));
        }
        if (object instanceof LocalDate) {
            return this.fixInfinity(this.dateFormatter.formatDate((LocalDate)object));
        }
        if (object instanceof Date) {
            return this.fixInfinity(this.dateFormatter.formatDate((Date)object));
        }
        if (object instanceof java.util.Date) {
            return this.fixInfinity(this.dateFormatter.formatUtilDate((java.util.Date)object));
        }
        if (object instanceof File) {
            File file = (File)object;
            String string4 = null;
            try {
                string4 = file.getCanonicalPath();
            }
            catch (Exception exception) {
                string4 = file.getAbsolutePath();
            }
            if (SqlUtil.isBlobType(n)) {
                return "{$blobfile='" + string4 + "'}";
            }
            if (SqlUtil.isClobType(n)) {
                return "{$clobfile='" + string4 + "' encoding='" + this.clobEncoding + "'}";
            }
        } else {
            if (n == -7 && "bit".equalsIgnoreCase(string)) {
                try {
                    boolean bl = (Boolean)object;
                    return bl ? "1" : "0";
                }
                catch (Exception exception) {
                    return object.toString();
                }
            }
            if (SqlUtil.isBlobType(n)) {
                if (this.blobWriter != null) {
                    try {
                        File file = this.blobWriter.generateDataFileName(columnData);
                        this.blobWriter.writeBlobFile(object, file);
                        return "{$blobfile='" + file.getName() + "'}";
                    }
                    catch (Exception exception) {
                        LogMgr.logError(new CallerInfo(){}, "Could not write BLOB file", exception);
                    }
                } else if (this.blobFormatter != null) {
                    try {
                        return this.blobFormatter.getBlobLiteral(object);
                    }
                    catch (Exception exception) {
                        LogMgr.logError(new CallerInfo(){}, "Error converting BLOB value", exception);
                    }
                }
            } else {
                if ("hstore".equalsIgnoreCase(string) && object instanceof Map) {
                    return HstoreSupport.getLiteral((Map)object);
                }
                if (n == 2003) {
                    if (this.isOracle) {
                        return object.toString();
                    }
                    return "'" + object.toString() + "'";
                }
                if (n == 1111 && ("uuid".equalsIgnoreCase(string) || "json".equalsIgnoreCase(string) || "jsonb".equalsIgnoreCase(string))) {
                    return this.quoteString(n, object.toString());
                }
            }
        }
        return object.toString();
    }

    private String fixInfinity(String string) {
        if (string == null) {
            return null;
        }
        if (InfinityLiterals.isPGLiteral(string)) {
            return "'" + string + "'";
        }
        return string;
    }

    private boolean isDateTime(int n) {
        return n == 91 || n == 93 || n == 92 || n == 2014 || n == 2013;
    }

    private String cleanupTypeName(String string) {
        return StringUtil.replace(string, " ", "_").toLowerCase();
    }

    private String getDbmsFormat(String string) {
        if (this.dbSettings == null) {
            return null;
        }
        return SqlLiteralFormatter.getPattern(this.dbSettings.getDbId(), this.cleanupTypeName(string));
    }

    private synchronized String formatDbmsType(ColumnData columnData) {
        int n = columnData.getIdentifier().getDataType();
        if (!this.checkDBMSTypes || !this.isDateTime(n)) {
            return null;
        }
        String string = columnData.getIdentifier().getDbmsType();
        WbDateFormatter wbDateFormatter = this.dbmsFormatters.get(string);
        String string2 = null;
        if (wbDateFormatter == null) {
            string2 = this.getDbmsFormat(string);
            if (StringUtil.isEmptyString(string2)) {
                return null;
            }
            string2 = string2.replace("${dbtype}", string);
            try {
                wbDateFormatter = new WbDateFormatter(string2);
                this.dbmsFormatters.put(string, wbDateFormatter);
            }
            catch (Exception exception) {
                LogMgr.logWarning(new CallerInfo(){}, "Could not create formatter for type \"" + string + "\" using '" + string2 + "'", exception);
            }
        }
        if (wbDateFormatter == null) {
            return null;
        }
        Object object = columnData.getValue();
        try {
            if (WbDateFormatter.isDateTimeValue(object)) {
                return wbDateFormatter.formatDateTimeValue(object);
            }
            LogMgr.logWarning(new CallerInfo(){}, "Value class " + object.getClass().getName() + " cannot be formatted as a date/time value");
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not format type \"" + string + "\" using '" + string2 + "'", exception);
        }
        return null;
    }
}

