/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.ArrayConverter;
import workbench.util.SqlUtil;

public class StructConverter {
    private final SimpleDateFormat timestampFormatter = new SimpleDateFormat("'TIMESTAMP '''yyyy-MM-dd HH:mm:ss''");
    private final SimpleDateFormat dateFormatter;
    private final SimpleDateFormat timeFormatter = new SimpleDateFormat("'TIME '''HH:mm:ss''");
    private final DecimalFormat numberFormatter;

    public static StructConverter getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private StructConverter() {
        this.dateFormatter = new SimpleDateFormat("'DATE '''yyyy-MM-dd''");
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        this.numberFormatter = new DecimalFormat("0.#", decimalFormatSymbols);
        this.numberFormatter.setMinimumIntegerDigits(0);
        this.numberFormatter.setMaximumFractionDigits(100);
    }

    public String getStructDisplay(Struct struct, boolean bl) throws SQLException {
        if (struct == null) {
            return null;
        }
        Object[] objectArray = struct.getAttributes();
        if (objectArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(objectArray.length * 20);
        String string = struct.getSQLTypeName();
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append('(');
        boolean bl2 = true;
        for (Object object : objectArray) {
            if (!bl2) {
                stringBuilder.append(", ");
            } else {
                bl2 = false;
            }
            if (object == null) {
                stringBuilder.append("NULL");
                continue;
            }
            if (object instanceof Struct) {
                stringBuilder.append(this.getStructDisplay((Struct)object, bl));
                continue;
            }
            if (object instanceof Array) {
                stringBuilder.append(this.getArrayDisplay(object, bl));
                continue;
            }
            this.appendValue(stringBuilder, object);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendValue(StringBuilder stringBuilder, Object object) {
        if (object instanceof CharSequence) {
            stringBuilder.append('\'');
            stringBuilder.append(SqlUtil.escapeQuotes(object.toString()));
            stringBuilder.append('\'');
        } else if (object instanceof Timestamp) {
            SimpleDateFormat simpleDateFormat = this.timestampFormatter;
            synchronized (simpleDateFormat) {
                stringBuilder.append(this.timestampFormatter.format((Timestamp)object));
            }
        } else if (object instanceof Time) {
            SimpleDateFormat simpleDateFormat = this.timeFormatter;
            synchronized (simpleDateFormat) {
                stringBuilder.append(this.timeFormatter.format((Time)object));
            }
        } else if (object instanceof Date) {
            SimpleDateFormat simpleDateFormat = this.dateFormatter;
            synchronized (simpleDateFormat) {
                stringBuilder.append(this.dateFormatter.format((Date)object));
            }
        } else if (object instanceof Number) {
            DecimalFormat decimalFormat = this.numberFormatter;
            synchronized (decimalFormat) {
                stringBuilder.append(this.numberFormatter.format(object));
            }
        } else {
            stringBuilder.append(object.toString());
        }
    }

    private String getArrayDisplay(Object object, boolean bl) throws SQLException {
        String string = this.getOracleTypeName(object);
        if (string == null && object instanceof Array) {
            try {
                return ((Array)object).getBaseTypeName();
            }
            catch (Throwable throwable) {
                string = "ARRAY";
            }
        }
        return ArrayConverter.getArrayDisplay(object, string, true, bl);
    }

    private String getOracleTypeName(Object object) {
        if (!object.getClass().getName().equals("oracle.sql.ARRAY")) {
            return null;
        }
        try {
            Method method = object.getClass().getMethod("getSQLTypeName", null);
            method.setAccessible(true);
            Object object2 = method.invoke(object, (Object[])null);
            if (object2 != null) {
                return object2.toString();
            }
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not get data type name", throwable);
        }
        return null;
    }

    private static class InstanceHolder {
        private static final StructConverter INSTANCE = new StructConverter();

        private InstanceHolder() {
        }
    }
}

