/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObjectFinder;
import workbench.db.DbSearchPath;
import workbench.db.IndexColumn;
import workbench.db.IndexDefinition;
import workbench.db.IndexReader;
import workbench.db.PkDefinition;
import workbench.db.ReaderFactory;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.ResultInfo;
import workbench.util.CollectionUtil;

public class UpdateTableDetector {
    private TableIdentifier updateTable;
    private List<ColumnIdentifier> missingPkcolumns;
    private WbConnection conn;
    private boolean checkPkOnly;

    public UpdateTableDetector(WbConnection wbConnection) {
        this.conn = wbConnection;
    }

    public void setCheckPKOnly(boolean bl) {
        this.checkPkOnly = bl;
    }

    public TableIdentifier getUpdateTable() {
        return this.updateTable;
    }

    public List<ColumnIdentifier> getMissingPkColumns() {
        return this.missingPkcolumns;
    }

    public void checkUpdateTable(TableIdentifier tableIdentifier, ResultInfo resultInfo) {
        this.updateTable = null;
        resultInfo.setUpdateTable(null);
        this.missingPkcolumns = null;
        if (tableIdentifier == null) {
            return;
        }
        DbMetadata dbMetadata = this.conn.getMetadata();
        if (dbMetadata == null) {
            return;
        }
        TableIdentifier tableIdentifier2 = this.getFullyQualifiedTable(tableIdentifier);
        if (tableIdentifier2 == null) {
            return;
        }
        tableIdentifier2.adjustCase(this.conn);
        CallerInfo callerInfo = new CallerInfo(){};
        if (this.checkPkOnly) {
            LogMgr.logDebug(callerInfo, "Only checking the PK definition for " + tableIdentifier2.getTableExpression());
            this.checkPkOnlyForUpdateTable(tableIdentifier2, resultInfo);
            if (this.updateTable != null) {
                LogMgr.logDebug(callerInfo, "Using update table: " + this.updateTable.getTableExpression());
                return;
            }
            tableIdentifier2 = this.findTable(tableIdentifier2);
        }
        List<ColumnIdentifier> list = null;
        try {
            TableDefinition tableDefinition = this.getDefinition(tableIdentifier2);
            if (tableDefinition != null && tableDefinition.getColumnCount() > 0 && tableDefinition.getTable() != null) {
                list = tableDefinition.getColumns();
                this.updateTable = dbMetadata.isSynonym(tableIdentifier2) ? tableIdentifier2 : tableDefinition.getTable();
            } else {
                this.updateTable = this.findTable(tableIdentifier2);
                list = this.getColumns(tableIdentifier2);
            }
            int n = 0;
            if (list != null) {
                this.missingPkcolumns = new ArrayList<ColumnIdentifier>(list.size());
                for (ColumnIdentifier columnIdentifier : list) {
                    int n2 = this.findColumn(columnIdentifier.getColumnName(), resultInfo);
                    if (n2 > -1) {
                        this.syncResultColumn(n2, columnIdentifier, resultInfo);
                        ++n;
                        continue;
                    }
                    if (!columnIdentifier.isPkColumn()) continue;
                    this.missingPkcolumns.add(columnIdentifier);
                }
            }
            if (n == 0 && this.updateTable != null) {
                LogMgr.logWarning(callerInfo, "No columns from the table " + this.updateTable.getTableExpression() + " could be found in the current result set!");
            }
            if (!resultInfo.hasPkColumns() && dbMetadata.getDbSettings().checkUniqueIndexesForPK()) {
                this.checkUniqueIndexesFor(this.updateTable, resultInfo);
            }
        }
        catch (Exception exception) {
            this.updateTable = null;
            LogMgr.logError(callerInfo, "Could not read table definition", exception);
        }
        LogMgr.logDebug(callerInfo, "Using update table: " + this.updateTable);
        resultInfo.setUpdateTable(this.updateTable);
    }

    private int findColumn(String string, ResultInfo resultInfo) {
        int n;
        if (resultInfo.isColumnTableDetected() && this.updateTable != null) {
            for (n = 0; n < resultInfo.getColumnCount(); ++n) {
                String string2 = resultInfo.getColumn(n).getColumnName();
                if (!this.columNamesAreEqual(string, string2) || !this.columnBelongsToUpdateTable(resultInfo.getColumn(n), resultInfo)) continue;
                return n;
            }
        }
        if ((n = resultInfo.findColumn(string, this.conn.getMetadata())) > -1 && !this.isUniqueColumnName(string, resultInfo)) {
            LogMgr.logWarning(new CallerInfo(){}, "Column " + string + " is not unique. Ignoring column!");
            return -1;
        }
        return n;
    }

    private boolean isUniqueColumnName(String string, ResultInfo resultInfo) {
        int n = 0;
        for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
            if (this.columNamesAreEqual(resultInfo.getColumnName(i), string)) {
                ++n;
            }
            if (n > 1) break;
        }
        return n == 1;
    }

    private boolean columnBelongsToUpdateTable(ColumnIdentifier columnIdentifier, ResultInfo resultInfo) {
        if (columnIdentifier.getSourceTableName() == null) {
            return false;
        }
        TableIdentifier tableIdentifier = new TableIdentifier(columnIdentifier.getSourceTableName());
        return this.updateTable.compareNames(tableIdentifier);
    }

    private boolean columNamesAreEqual(String string, String string2) {
        string = this.conn.getMetadata().removeQuotes(string);
        string2 = this.conn.getMetadata().removeQuotes(string2);
        return string.equalsIgnoreCase(string2);
    }

    private List<ColumnIdentifier> getColumns(TableIdentifier tableIdentifier) throws SQLException {
        TableIdentifier tableIdentifier2 = this.getFullyQualifiedTable(tableIdentifier);
        TableIdentifier tableIdentifier3 = this.getSynonymTable(tableIdentifier2);
        List<ColumnIdentifier> list = null;
        list = this.conn.getDbSettings().useCompletionCacheForUpdateTableCheck() ? this.conn.getObjectCache().getColumns(tableIdentifier3) : this.conn.getMetadata().getTableColumns(tableIdentifier3);
        return list;
    }

    private TableIdentifier getSynonymTable(TableIdentifier tableIdentifier) {
        if (!this.conn.getMetadata().supportsSynonyms()) {
            return tableIdentifier;
        }
        if (this.conn.getDbSettings().useCompletionCacheForUpdateTableCheck()) {
            return this.conn.getObjectCache().getSynonymTable(tableIdentifier);
        }
        return this.conn.getMetadata().resolveSynonym(tableIdentifier);
    }

    private void checkPkOnlyForUpdateTable(TableIdentifier tableIdentifier, ResultInfo resultInfo) {
        DbMetadata dbMetadata = this.conn.getMetadata();
        if (dbMetadata == null) {
            return;
        }
        if (resultInfo == null) {
            return;
        }
        PkDefinition pkDefinition = null;
        long l = System.currentTimeMillis();
        pkDefinition = this.conn.getDbSettings().useCompletionCacheForUpdateTableCheck() ? this.conn.getObjectCache().getPrimaryKey(tableIdentifier) : dbMetadata.getIndexReader().getPrimaryKey(tableIdentifier);
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logInfo(new CallerInfo(){}, "Retrieving primary key for table " + tableIdentifier.getTableExpression() + " took: " + l2 + "ms");
        this.missingPkcolumns = new ArrayList<ColumnIdentifier>(1);
        if (pkDefinition == null || CollectionUtil.isEmpty(pkDefinition.getColumns())) {
            this.checkUniqueIndexesFor(tableIdentifier, resultInfo);
        } else {
            for (String string : pkDefinition.getColumns()) {
                int n = resultInfo.findColumn(string, this.conn.getMetadata());
                if (n > -1) {
                    resultInfo.setIsPkColumn(n, true);
                    resultInfo.setIsNullable(n, false);
                    continue;
                }
                this.missingPkcolumns.add(new ColumnIdentifier(string));
            }
        }
        if (resultInfo.hasPkColumns()) {
            this.updateTable = tableIdentifier;
            resultInfo.setUpdateTable(this.updateTable);
        }
    }

    private void checkUniqueIndexesFor(TableIdentifier tableIdentifier, ResultInfo resultInfo) {
        if (tableIdentifier == null || resultInfo == null) {
            return;
        }
        LogMgr.logInfo(new CallerInfo(){}, "No PK found for table " + tableIdentifier.getTableName() + " Trying to find an unique index.");
        List<IndexDefinition> list = null;
        long l = System.currentTimeMillis();
        if (this.conn.getDbSettings().useCompletionCacheForUpdateTableCheck()) {
            list = this.conn.getObjectCache().getUniqueIndexes(tableIdentifier);
        } else {
            IndexReader indexReader = ReaderFactory.getIndexReader(this.conn.getMetadata());
            list = indexReader.getUniqueIndexes(tableIdentifier);
        }
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logInfo(new CallerInfo(){}, "Retrieving unique indexes for table " + tableIdentifier.getTableExpression() + " took: " + l2 + "ms");
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        IndexDefinition indexDefinition = this.findSuitableIndex(list, resultInfo);
        if (indexDefinition == null) {
            LogMgr.logDebug(new CallerInfo(){}, "No unique index found for table: " + tableIdentifier.getTableExpression());
            return;
        }
        LogMgr.logInfo(new CallerInfo(){}, "Using unique index " + indexDefinition.getObjectName() + " as a surrogate PK for table: " + tableIdentifier.getTableExpression());
        List<IndexColumn> list2 = indexDefinition.getColumns();
        for (IndexColumn indexColumn : list2) {
            int n = resultInfo.findColumn(indexColumn.getColumn(), this.conn.getMetadata());
            if (n > -1) {
                resultInfo.setIsPkColumn(n, true);
                resultInfo.setIsNullable(n, false);
                continue;
            }
            this.missingPkcolumns.add(new ColumnIdentifier(indexColumn.getColumn()));
        }
    }

    private IndexDefinition findSuitableIndex(List<IndexDefinition> list, ResultInfo resultInfo) {
        for (IndexDefinition indexDefinition : list) {
            if (this.hasNullableColumns(indexDefinition, resultInfo)) continue;
            return indexDefinition;
        }
        return null;
    }

    private boolean hasNullableColumns(IndexDefinition indexDefinition, ResultInfo resultInfo) {
        for (IndexColumn indexColumn : indexDefinition.getColumns()) {
            int n = resultInfo.findColumn(indexColumn.getColumn(), this.conn.getMetadata());
            if (n <= -1 || !resultInfo.getColumn(n).isNullable()) continue;
            return true;
        }
        return false;
    }

    public void syncResultColumn(int n, ColumnIdentifier columnIdentifier, ResultInfo resultInfo) {
        boolean bl = true;
        if (!columnIdentifier.isAutoGenerated() && columnIdentifier.getComputedColumnExpression() != null) {
            bl = false;
            LogMgr.logDebug(new CallerInfo(){}, "Column " + columnIdentifier.getColumnName() + " can not be updated because it is a computed column");
        }
        if (resultInfo.getColumn(n).isReadonly()) {
            LogMgr.logDebug(new CallerInfo(){}, "Column " + columnIdentifier.getColumnName() + " was marked as read-only by the driver!");
        }
        resultInfo.setUpdateable(n, bl);
        resultInfo.setIsPkColumn(n, columnIdentifier.isPkColumn());
        resultInfo.setIsNullable(n, columnIdentifier.isNullable());
        ColumnIdentifier columnIdentifier2 = resultInfo.getColumn(n);
        columnIdentifier2.setIsAutoincrement(columnIdentifier.isAutoincrement());
        columnIdentifier2.setComputedColumnExpression(columnIdentifier.getComputedColumnExpression());
    }

    private TableDefinition getDefinition(TableIdentifier tableIdentifier) throws SQLException {
        Object object;
        TableDefinition tableDefinition = null;
        if (this.conn.getDbSettings().useCompletionCacheForUpdateTableCheck() && (object = this.conn.getObjectCache().getColumns(tableIdentifier)) != null) {
            TableIdentifier tableIdentifier2 = this.conn.getObjectCache().getTable(tableIdentifier);
            tableDefinition = new TableDefinition(tableIdentifier2, (List<ColumnIdentifier>)object);
        }
        if (tableDefinition == null) {
            object = this.getFullyQualifiedTable(tableIdentifier);
            tableDefinition = this.conn.getMetadata().getTableDefinition((TableIdentifier)object);
        }
        return tableDefinition;
    }

    private TableIdentifier getFullyQualifiedTable(TableIdentifier tableIdentifier) {
        Object object;
        TableIdentifier tableIdentifier2 = tableIdentifier.createCopy();
        if (tableIdentifier2.getSchema() == null) {
            Object object2;
            object = DbSearchPath.Factory.getSearchPathHandler(this.conn);
            if (object.isRealSearchPath() && (object2 = object.getSearchPath(this.conn, null)).size() > 1) {
                return this.findTable(tableIdentifier);
            }
            object2 = this.conn.getMetadata().getCurrentSchema();
            if (object2 != null) {
                LogMgr.logDebug(new CallerInfo(){}, "Using current schema " + (String)object2 + " for update table " + tableIdentifier.getObjectName());
            }
            tableIdentifier2.setSchema((String)object2);
        }
        if (tableIdentifier2.getCatalog() == null) {
            object = this.conn.getMetadata().getCurrentCatalog();
            if (object != null) {
                LogMgr.logDebug(new CallerInfo(){}, "Using current catalog " + (String)object + " for update table " + tableIdentifier.getObjectName());
            }
            tableIdentifier2.setCatalog((String)object);
        }
        return tableIdentifier2;
    }

    private TableIdentifier findTable(TableIdentifier tableIdentifier) {
        TableIdentifier tableIdentifier2 = null;
        if (this.conn.getDbSettings().useCompletionCacheForUpdateTableCheck()) {
            tableIdentifier2 = this.conn.getObjectCache().getOrRetrieveTable(tableIdentifier);
        }
        if (tableIdentifier2 == null) {
            tableIdentifier2 = new DbObjectFinder(this.conn).searchSelectableObjectOnPath(tableIdentifier);
        }
        return tableIdentifier2;
    }
}

