/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage.filter;

import java.util.Map;
import workbench.gui.components.RowHighlighter;
import workbench.storage.filter.ColumnComparator;
import workbench.storage.filter.ExpressionValue;
import workbench.storage.filter.FilterExpression;
import workbench.util.StringUtil;

public class ColumnExpression
implements FilterExpression,
ExpressionValue,
RowHighlighter {
    private String columnName;
    private Object filterValue;
    private ColumnComparator comparator;
    private boolean ignoreCase;

    public ColumnExpression() {
    }

    public ColumnExpression(String string, ColumnComparator columnComparator, Object object) {
        this.setComparator(columnComparator);
        this.setFilterValue(object);
        this.setColumnName(string);
    }

    public ColumnExpression(ColumnComparator columnComparator, Object object) {
        this.setComparator(columnComparator);
        this.setFilterValue(object);
        this.setColumnName("*");
    }

    @Override
    public Object getFilterValue() {
        return this.filterValue;
    }

    public final void setFilterValue(Object object) {
        this.filterValue = object;
    }

    @Override
    public ColumnComparator getComparator() {
        return this.comparator;
    }

    public final void setComparator(ColumnComparator columnComparator) {
        this.comparator = columnComparator;
    }

    public boolean equals(Object object) {
        try {
            ColumnExpression columnExpression = (ColumnExpression)object;
            if (this.filterValue == null || columnExpression.filterValue == null) {
                return false;
            }
            boolean bl = this.filterValue.equals(columnExpression.filterValue);
            if (bl) {
                bl = this.comparator.equals(columnExpression.comparator);
            }
            return bl;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean evaluate(Object object) {
        if (object != null && !this.comparator.supportsType(object.getClass())) {
            return false;
        }
        return this.comparator.evaluate(this.filterValue, object, this.ignoreCase);
    }

    public boolean evaluate(Map map) {
        Object v = map.get(this.columnName);
        return this.evaluate(v);
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    public final void setColumnName(String string) {
        this.columnName = string == null ? null : string.toLowerCase();
    }

    public String toString() {
        return "[" + this.columnName + "] " + this.comparator.getOperator() + " " + this.comparator.getValueExpression(this.filterValue);
    }

    @Override
    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    @Override
    public boolean isColumnSpecific() {
        return !"*".equals(this.columnName);
    }

    @Override
    public boolean hightlightColumn(int n, String string, Object object) {
        if (!this.isColumnSpecific() || StringUtil.compareStrings(this.getColumnName(), string, true) == 0) {
            return this.evaluate(object);
        }
        return false;
    }
}

