/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage.filter;

import java.util.Map;
import workbench.storage.filter.ColumnComparator;
import workbench.storage.filter.ExpressionValue;
import workbench.storage.filter.FilterExpression;

public class DataRowExpression
implements FilterExpression,
ExpressionValue {
    private Object filterValue;
    private ColumnComparator comparator;
    private boolean ignoreCase;

    public DataRowExpression() {
    }

    public DataRowExpression(ColumnComparator columnComparator, Object object) {
        this.setComparator(columnComparator);
        this.setFilterValue(object);
    }

    @Override
    public Object getFilterValue() {
        return this.filterValue;
    }

    public final void setFilterValue(Object object) {
        this.filterValue = object;
    }

    @Override
    public ColumnComparator getComparator() {
        return this.comparator;
    }

    public final void setComparator(ColumnComparator columnComparator) {
        this.comparator = columnComparator;
    }

    public boolean equals(Object object) {
        try {
            DataRowExpression dataRowExpression = (DataRowExpression)object;
            if (this.filterValue == null || dataRowExpression.filterValue == null) {
                return false;
            }
            boolean bl = this.filterValue.equals(dataRowExpression.filterValue);
            if (bl) {
                bl = this.comparator.equals(dataRowExpression.comparator);
            }
            return bl;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public boolean evaluate(Map<String, Object> map) {
        for (Object object : map.values()) {
            boolean bl;
            if (object == null || this.isArray(object) || !(bl = this.comparator.evaluate(this.filterValue, object.toString(), this.ignoreCase))) continue;
            return true;
        }
        return false;
    }

    private boolean isArray(Object object) {
        if (object == null) {
            return false;
        }
        String string = object.getClass().getName();
        return string.charAt(0) == '[';
    }

    public String toString() {
        return "[any column] " + this.comparator.getOperator() + " " + this.comparator.getValueExpression(this.filterValue);
    }

    @Override
    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    @Override
    public String getColumnName() {
        return "*";
    }

    @Override
    public boolean isColumnSpecific() {
        return false;
    }
}

