/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage.reader;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.TimeZone;
import workbench.db.ConnectionMgr;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.ResultInfo;
import workbench.storage.reader.ResultHolder;
import workbench.storage.reader.RowDataReader;

public class OracleRowDataReader
extends RowDataReader {
    private Method stringValueTZ;
    private Method offsetDateTimeValueTZ;
    private Method getTimeZoneTZ;
    private Method localDateTimeValueLTZ;
    private Method timestampValue;
    private Method timestampValueLTZ;
    private Connection sqlConnection;
    private DateTimeFormatter tsParser;
    private boolean useDefaultClassLoader;
    private Calendar sessionTimezone;

    public OracleRowDataReader(ResultInfo resultInfo, WbConnection wbConnection) throws ClassNotFoundException {
        this(resultInfo, wbConnection, false);
    }

    public OracleRowDataReader(ResultInfo resultInfo, WbConnection wbConnection, boolean bl) throws ClassNotFoundException {
        super(resultInfo, wbConnection);
        Object object;
        this.useDefaultClassLoader = bl;
        this.sqlConnection = wbConnection.getSqlConnection();
        CallerInfo callerInfo = new CallerInfo(){};
        if (JdbcUtils.hasMiniumDriverVersion(wbConnection, "11.2")) {
            object = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, true).optionalStart().appendLiteral(' ').appendZoneOrOffsetId().optionalEnd();
            this.tsParser = ((DateTimeFormatterBuilder)object).toFormatter().withResolverStyle(ResolverStyle.SMART);
        } else {
            object = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NEVER).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NEVER).appendLiteral('.').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NEVER).appendLiteral('.').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NEVER).appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, true).optionalStart().appendLiteral(' ').appendZoneOrOffsetId().optionalEnd();
            this.tsParser = ((DateTimeFormatterBuilder)object).toFormatter().withResolverStyle(ResolverStyle.LENIENT);
        }
        try {
            object = this.loadClass(wbConnection, "oracle.sql.TIMESTAMP");
            this.timestampValue = ((Class)object).getMethod("timestampValue", null);
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(callerInfo, "Could not access oracle.sql.TIMESTAMP", throwable);
        }
        try {
            object = this.loadClass(wbConnection, "oracle.sql.TIMESTAMPTZ");
            this.stringValueTZ = ((Class)object).getMethod("stringValue", Connection.class);
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(callerInfo, "Could not access oracle.sql.TIMESTAMPTZ", throwable);
        }
        try {
            object = this.loadClass(wbConnection, "oracle.sql.TIMESTAMPLTZ");
            this.timestampValueLTZ = ((Class)object).getMethod("timestampValue", Connection.class, Calendar.class);
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(callerInfo, "Class oracle.sql.TIMESTAMPLTZ not available!", throwable);
        }
        if (JdbcUtils.hasMiniumDriverVersion(wbConnection, "12.2")) {
            try {
                object = this.loadClass(wbConnection, "oracle.sql.TIMESTAMPTZ");
                this.offsetDateTimeValueTZ = ((Class)object).getMethod("offsetDateTimeValue", Connection.class);
                this.getTimeZoneTZ = ((Class)object).getMethod("getTimeZone", null);
                Class clazz = this.loadClass(wbConnection, "oracle.sql.TIMESTAMPLTZ");
                this.localDateTimeValueLTZ = clazz.getMethod("localDateTimeValue", Connection.class);
            }
            catch (Throwable throwable) {
                LogMgr.logWarning(new CallerInfo(){}, "Class oracle.sql.TIMESTAMPTZ not available!", throwable);
            }
        }
        this.initSessionTimezone(wbConnection);
    }

    private void initSessionTimezone(WbConnection wbConnection) {
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            Connection connection = wbConnection.getSqlConnection();
            Method method = connection.getClass().getMethod("getSessionTimeZone", null);
            method.setAccessible(true);
            String string = (String)method.invoke((Object)connection, new Object[0]);
            TimeZone timeZone = TimeZone.getTimeZone(string);
            this.sessionTimezone = Calendar.getInstance(timeZone);
            LogMgr.logDebug(callerInfo, "Using session time zone: " + timeZone.getID());
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(callerInfo, "Could not initialize session time zone", throwable);
        }
        if (this.sessionTimezone == null) {
            this.sessionTimezone = Calendar.getInstance();
            LogMgr.logWarning(callerInfo, "Could not obtain session time zone from the driver. Using system time zone: " + this.sessionTimezone.getTimeZone().getID());
        }
    }

    private Class loadClass(WbConnection wbConnection, String string) throws ClassNotFoundException {
        if (this.useDefaultClassLoader) {
            return Class.forName(string);
        }
        return ConnectionMgr.getInstance().loadClassFromDriverLib(wbConnection.getProfile(), string);
    }

    @Override
    protected Object readTimestampTZValue(ResultHolder resultHolder, int n) throws SQLException {
        return this.readTimestampValue(resultHolder, n);
    }

    @Override
    protected Object readTimestampValue(ResultHolder resultHolder, int n) throws SQLException {
        Object object = resultHolder.getObject(n);
        if (object == null) {
            return null;
        }
        if (resultHolder.wasNull()) {
            return null;
        }
        if (object instanceof Timestamp) {
            return object;
        }
        Object object2 = null;
        String string = object.getClass().getName();
        if ("oracle.sql.TIMESTAMPTZ".equals(string)) {
            if (this.offsetDateTimeValueTZ != null) {
                object2 = this.convertUsingOffsetDateTime(object);
            } else if (this.stringValueTZ != null) {
                object2 = this.convertTZFromString(object);
            }
        } else if ("oracle.sql.TIMESTAMPLTZ".equals(string)) {
            object2 = this.convertTIMESTAMPLTZ(object);
        } else if ("oracle.sql.TIMESTAMP".equals(string) && this.timestampValue != null) {
            object2 = this.convertTIMESTAMP(object);
        }
        if (object2 != null) {
            return object2;
        }
        return resultHolder.getTimestamp(n);
    }

    private ZoneId getTimeZone(Object object) {
        try {
            TimeZone timeZone = (TimeZone)this.getTimeZoneTZ.invoke(object, (Object[])null);
            return timeZone.toZoneId();
        }
        catch (Throwable throwable) {
            LogMgr.logDebug(new CallerInfo(){}, "Could not retrieve time zone", throwable);
            return null;
        }
    }

    private Object convertUsingOffsetDateTime(Object object) {
        try {
            OffsetDateTime offsetDateTime = (OffsetDateTime)this.offsetDateTimeValueTZ.invoke(object, this.sqlConnection);
            ZoneId zoneId = this.getTimeZone(object);
            if (zoneId != null) {
                return offsetDateTime.atZoneSameInstant(zoneId);
            }
            return offsetDateTime.toZonedDateTime();
        }
        catch (Throwable throwable) {
            LogMgr.logDebug(new CallerInfo(){}, "Could not convert timestamp", throwable);
            return object;
        }
    }

    private Object convertTIMESTAMPLTZ(Object object) {
        try {
            if (this.localDateTimeValueLTZ != null) {
                return this.localDateTimeValueLTZ.invoke(object, this.sqlConnection);
            }
            if (this.timestampValueLTZ != null) {
                Timestamp timestamp = (Timestamp)this.timestampValueLTZ.invoke(object, this.sqlConnection, this.sessionTimezone);
                return timestamp;
            }
        }
        catch (Throwable throwable) {
            LogMgr.logDebug(new CallerInfo(){}, "Could not convert TIMESTAMPLTZ", throwable);
        }
        return object;
    }

    private Object convertTIMESTAMP(Object object) {
        try {
            return this.timestampValue.invoke(object, new Object[0]);
        }
        catch (Throwable throwable) {
            LogMgr.logDebug(new CallerInfo(){}, "Could not convert convertTIMESTAMP", throwable);
            return object;
        }
    }

    private Object convertTZFromString(Object object) {
        String string = null;
        try {
            string = (String)this.stringValueTZ.invoke(object, this.sqlConnection);
            return ZonedDateTime.parse(string, this.tsParser);
        }
        catch (Throwable throwable) {
            this.stringValueTZ = null;
            LogMgr.logDebug(new CallerInfo(){}, "Could not parse timestamp string: " + string, throwable);
            return null;
        }
    }
}

