/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage.reader;

import java.sql.SQLException;
import java.util.Set;
import java.util.TreeSet;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.ResultInfo;
import workbench.storage.reader.ResultHolder;
import workbench.storage.reader.RowDataReader;

public class SQLiteRowDataReader
extends RowDataReader {
    private final Set<Integer> columnsWithErrors = new TreeSet<Integer>();

    public SQLiteRowDataReader(ResultInfo resultInfo, WbConnection wbConnection) {
        super(resultInfo, wbConnection);
    }

    @Override
    public Object readColumnData(ResultHolder resultHolder, int n, int n2, boolean bl) throws SQLException {
        switch (n) {
            case 91: 
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                return resultHolder.getString(n2);
            }
        }
        try {
            if (this.columnsWithErrors.contains(n2)) {
                return resultHolder.getString(n2);
            }
            return resultHolder.getObject(n2);
        }
        catch (Throwable throwable) {
            if (!this.columnsWithErrors.contains(n2)) {
                LogMgr.logWarning(new CallerInfo(){}, "Could not retrieve value from column " + n2 + " using getObject(), using getString()", throwable);
                this.columnsWithErrors.add(n2);
            }
            return resultHolder.getString(n2);
        }
    }
}

