/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.util.StringUtil;

public class Alias {
    protected String objectName;
    private String alias;
    private String display;
    private String asKeyword;
    private int startPosInQuery = -1;
    private int endPosInQuery = -1;

    public Alias() {
    }

    public Alias(String string, String string2) {
        this.objectName = string;
        this.alias = string2;
    }

    public void setStartPositionInQuery(int n) {
        this.startPosInQuery = n;
    }

    public int getStartPositionInQuery() {
        return this.startPosInQuery;
    }

    public void setEndPositionInQuery(int n) {
        this.endPosInQuery = n;
    }

    public int getEndPositionInQuery() {
        return this.endPosInQuery;
    }

    public Alias(String string) {
        if (StringUtil.isEmptyString(string)) {
            throw new IllegalArgumentException("Identifier must not be empty");
        }
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(string);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        SQLToken sQLToken = sQLLexer.getNextToken(false, true);
        boolean bl = true;
        while (sQLToken != null) {
            if (sQLToken.isWhiteSpace()) {
                bl = false;
            }
            if (bl) {
                stringBuilder.append(sQLToken.getText());
            } else if ("AS".equals(sQLToken.getContents())) {
                bl = false;
            } else {
                this.alias = sQLToken.getText();
            }
            sQLToken = sQLLexer.getNextToken(false, true);
        }
        this.objectName = stringBuilder.toString();
        this.display = string;
    }

    public void setAsKeyword(String string) {
        this.asKeyword = string;
    }

    public boolean isNotEmpty() {
        return StringUtil.isNonEmpty(this.objectName);
    }

    public void appendObjectName(String string) {
        this.objectName = this.objectName == null ? string : this.objectName + string;
    }

    public void setObjectName(String string) {
        this.objectName = string;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public final String getAlias() {
        return this.alias;
    }

    public final String getObjectName() {
        return this.objectName;
    }

    public String getName() {
        if (this.alias != null) {
            return StringUtil.concatWithSeparator(" ", this.objectName, this.asKeyword, this.alias);
        }
        return this.objectName;
    }

    public final String getNameToUse() {
        if (this.alias == null) {
            return this.objectName;
        }
        return this.alias;
    }

    public String toString() {
        if (this.display == null) {
            this.display = this.alias == null ? this.objectName : this.alias + " (" + this.objectName + ")";
        }
        return this.display;
    }

    public String debugString() {
        return "Name: " + this.objectName + ", alias: " + StringUtil.coalesce(this.alias, "") + ", start: " + this.startPosInQuery + ", end: " + this.endPosInQuery;
    }

    public int hashCode() {
        int n = 7;
        n = 47 * n + (this.objectName != null ? this.objectName.hashCode() : 0);
        n = 47 * n + (this.alias != null ? this.alias.hashCode() : 0);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Alias alias = (Alias)object;
        if (StringUtil.equalStringIgnoreCase(this.objectName, alias.objectName)) {
            return StringUtil.equalStringIgnoreCase(this.alias, alias.alias);
        }
        return false;
    }
}

