/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.IOException;
import java.io.Reader;

public class CharSequenceReader
extends Reader {
    private final Object readLock = new Object();
    private CharSequence str;
    private int length;
    private int next = 0;
    private int mark = 0;

    public CharSequenceReader(CharSequence charSequence) {
        this.str = charSequence;
        this.length = charSequence.length();
    }

    private void ensureOpen() throws IOException {
        if (this.str == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            this.ensureOpen();
            if (this.next >= this.length) {
                return -1;
            }
            return this.str.charAt(this.next++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            this.ensureOpen();
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.next >= this.length) {
                return -1;
            }
            int n3 = Math.min(this.length - this.next, n2);
            int n4 = n;
            for (int i = this.next; i < this.next + n3; ++i) {
                cArray[n4] = this.str.charAt(i);
                ++n4;
            }
            this.next += n3;
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long l) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            this.ensureOpen();
            if (this.next >= this.length) {
                return 0L;
            }
            long l2 = Math.min((long)(this.length - this.next), l);
            l2 = Math.max((long)(-this.next), l2);
            this.next = (int)((long)this.next + l2);
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            this.ensureOpen();
            return true;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        Object object = this.readLock;
        synchronized (object) {
            this.ensureOpen();
            this.mark = this.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            this.ensureOpen();
            this.next = this.mark;
        }
    }

    @Override
    public void close() {
        this.str = null;
    }
}

