/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import workbench.resource.ResourceMgr;

public class CharacterRange {
    public static final CharacterRange RANGE_NONE = new CharacterRange(0);
    public static final CharacterRange RANGE_CONTROL = new CharacterRange(1);
    public static final CharacterRange RANGE_7BIT = new CharacterRange(2);
    public static final CharacterRange RANGE_8BIT = new CharacterRange(3);
    public static final CharacterRange RANGE_8BIT_EXTENDED = new CharacterRange(4);
    private int typeIndex = 0;

    private CharacterRange(int n) {
        this.typeIndex = n;
    }

    public static CharacterRange[] getRanges() {
        return new CharacterRange[]{RANGE_NONE, RANGE_CONTROL, RANGE_7BIT, RANGE_8BIT, RANGE_8BIT_EXTENDED};
    }

    public String getName() {
        switch (this.typeIndex) {
            case 1: {
                return "control";
            }
            case 2: {
                return "7bit";
            }
            case 3: {
                return "8bit";
            }
            case 4: {
                return "extended";
            }
        }
        return "none";
    }

    public static CharacterRange getRangeByName(String string) {
        for (CharacterRange characterRange : CharacterRange.getRanges()) {
            if (!characterRange.getName().equalsIgnoreCase(string)) continue;
            return characterRange;
        }
        return RANGE_NONE;
    }

    public static CharacterRange getRangeById(int n) {
        switch (n) {
            case 0: {
                return RANGE_NONE;
            }
            case 1: {
                return RANGE_CONTROL;
            }
            case 2: {
                return RANGE_7BIT;
            }
            case 3: {
                return RANGE_8BIT;
            }
            case 4: {
                return RANGE_8BIT_EXTENDED;
            }
        }
        return null;
    }

    public int getId() {
        return this.typeIndex;
    }

    public boolean isOutsideRange(char c) {
        switch (this.typeIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return c < ' ';
            }
            case 2: {
                return c < ' ' || c > '~';
            }
            case 3: {
                return c < ' ' || c > '\u00ff';
            }
            case 4: {
                return c < ' ' || c > '~' && c < '\u00a1' || c > '\u00ff';
            }
        }
        return false;
    }

    public String getFilterDescription() {
        switch (this.typeIndex) {
            case 0: {
                return ResourceMgr.getString("LblNone");
            }
            case 1: {
                return ResourceMgr.getString("LblExportRangeCtrl");
            }
            case 2: {
                return ResourceMgr.getString("LblExportRange7Bit");
            }
            case 3: {
                return ResourceMgr.getString("LblExportRange8Bit");
            }
            case 4: {
                return ResourceMgr.getString("LblExportRange8BitExtended");
            }
        }
        return "";
    }

    public String toString() {
        return this.getFilterDescription();
    }
}

