/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.ClassInfo;
import workbench.util.ClasspathUtil;
import workbench.util.CollectionUtil;
import workbench.util.PlatformHelper;
import workbench.util.ZipUtil;

public class ClassFinder {
    private final Class toFind;
    private Set<String> excludedClasses = Collections.emptySet();
    private boolean searchForServices = true;

    public ClassFinder(Class clazz) {
        this.toFind = clazz;
    }

    public void setSearchForServices(boolean bl) {
        this.searchForServices = bl;
    }

    public void setExcludedClasses(Collection<String> collection) {
        if (collection != null) {
            this.excludedClasses = new TreeSet<String>(collection);
        }
    }

    private List<File> adjustFiles(List<File> list) {
        ClasspathUtil classpathUtil = new ClasspathUtil();
        if (classpathUtil.isExtDir(list)) {
            return classpathUtil.getExtLibs();
        }
        return list;
    }

    public List<String> findImplementations(List<File> list) throws IOException {
        List<String> list2;
        ClassLoader classLoader = this.buildClassLoader(list);
        list = this.adjustFiles(list);
        if (this.searchForServices) {
            list2 = this.getServices(classLoader);
            if (CollectionUtil.isNonEmpty(list2)) {
                LogMgr.logInfo(new CallerInfo(){}, "Using drivers specified in the service definition of the driver jars: " + list2);
                return list2;
            }
            LogMgr.logInfo(new CallerInfo(){}, "No services defined in the driver jar file(s). Scanning all classes");
        }
        list2 = new ArrayList<String>();
        for (File file : list) {
            if (!file.isFile()) continue;
            List<String> list3 = this.processJarFile(file, classLoader);
            list2.addAll(list3);
        }
        return list2;
    }

    public List<ClassInfo> findImplementingClasses(List<File> list) throws IOException {
        ClassLoader classLoader = this.buildClassLoader(list);
        list = this.adjustFiles(list);
        ArrayList<ClassInfo> arrayList = new ArrayList<ClassInfo>();
        for (File file : list) {
            if (!file.isFile()) continue;
            List<String> list2 = this.processJarFile(file, classLoader);
            for (String string : list2) {
                arrayList.add(new ClassInfo(string, file));
            }
        }
        return arrayList;
    }

    private List<String> processJarFile(File file, ClassLoader classLoader) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<Class> list = ClassFinder.scanJarFile(file, classLoader, this.excludedClasses);
        for (Class clazz : list) {
            try {
                if (!this.toFind.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers())) continue;
                arrayList.add(clazz.getCanonicalName());
            }
            catch (Throwable throwable) {}
        }
        return arrayList;
    }

    private List<String> getServices(ClassLoader classLoader) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            ServiceLoader<Driver> serviceLoader = ServiceLoader.load(this.toFind, classLoader);
            for (Driver driver : serviceLoader) {
                arrayList.add(driver.getClass().getName());
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not load services", throwable);
            return null;
        }
    }

    private static List<Class> scanJarFile(File file, ClassLoader classLoader, Set<String> set) throws IOException {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        if (!file.exists()) {
            LogMgr.logError(new CallerInfo(){}, "Cannot scan archived file " + file, new FileNotFoundException(file.getAbsolutePath()));
        }
        if (!ZipUtil.isZipFile(file)) {
            return arrayList;
        }
        LogMgr.logDebug(new CallerInfo(){}, "Scanning archived file " + file);
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                String string;
                JarEntry jarEntry = enumeration.nextElement();
                String string2 = jarEntry.getName();
                if (!string2.endsWith(".class") || string2.indexOf(36) > -1 || set.contains(string = string2.replace(".class", "").replace("/", "."))) continue;
                try {
                    Class<?> clazz = classLoader.loadClass(string);
                    arrayList.add(clazz);
                }
                catch (Throwable throwable) {}
            }
        }
        return arrayList;
    }

    private ClassLoader buildClassLoader(List<File> list) throws MalformedURLException {
        if (list == null) {
            return null;
        }
        ClasspathUtil classpathUtil = new ClasspathUtil();
        if (classpathUtil.isExtDir(list)) {
            return ClassLoader.getSystemClassLoader();
        }
        URL[] uRLArray = new URL[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            uRLArray[i] = list.get(i).toURI().toURL();
        }
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
        return uRLClassLoader;
    }

    public static List<Class> getClasses(String string) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return ClassFinder.getClasses(string, classLoader);
    }

    public static List<Class> getClasses(String string, ClassLoader classLoader) throws ClassNotFoundException, IOException {
        assert (classLoader != null);
        String string2 = string.replace('.', '/');
        ArrayList<Class> arrayList = new ArrayList<Class>();
        Enumeration<URL> enumeration = classLoader.getResources(string2);
        ArrayList<File> arrayList2 = new ArrayList<File>();
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            String object = uRL.getFile();
            String string3 = URLDecoder.decode(object, "UTF-8");
            if (string3.startsWith("file:") && string3.toLowerCase().contains("jar!")) {
                String string4 = PlatformHelper.isWindows() && string3.startsWith("file:/") ? string3.substring("file:/".length(), string3.indexOf(33)) : string3.substring("file:".length(), string3.indexOf(33));
                File file = new File(string4);
                Set<String> set = Collections.emptySet();
                List<Class> list = ClassFinder.scanJarFile(file, classLoader, set);
                for (Class clazz : list) {
                    if (clazz.getPackage() == null || !clazz.getPackage().getName().startsWith(string)) continue;
                    arrayList.add(clazz);
                }
                continue;
            }
            arrayList2.add(new File(string3));
        }
        for (File file : arrayList2) {
            LogMgr.logDebug(new CallerInfo(){}, "Try to find files in directory " + file.getAbsolutePath());
            arrayList.addAll(ClassFinder.findClasses(file, string));
        }
        return arrayList;
    }

    private static List<Class> findClasses(File file, String string) throws ClassNotFoundException {
        File[] fileArray;
        ArrayList<Class> arrayList = new ArrayList<Class>();
        if (!file.exists()) {
            return arrayList;
        }
        for (File file2 : fileArray = file.listFiles()) {
            String string2 = file2.getName();
            if (file2.isDirectory()) {
                assert (!string2.contains("."));
                arrayList.addAll(ClassFinder.findClasses(file2, string + "." + string2));
                continue;
            }
            if (!string2.endsWith(".class") || string2.contains("$")) continue;
            try {
                Class<?> clazz = Class.forName(string + '.' + string2.substring(0, string2.length() - 6));
                arrayList.add(clazz);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList;
    }
}

