/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import workbench.util.CaseInsensitiveComparator;

public class CollectionUtil {
    public static boolean isEmpty(Object ... objectArray) {
        if (objectArray == null) {
            return true;
        }
        if (objectArray.length == 0) {
            return true;
        }
        for (Object object : objectArray) {
            if (object == null) continue;
            return false;
        }
        return true;
    }

    public static void clear(Collection collection) {
        if (collection != null) {
            collection.clear();
        }
    }

    public static <E extends Collection> E firstNonEmpty(E ... EArray) {
        if (EArray == null) {
            return (E)Collections.emptyList();
        }
        for (E e : EArray) {
            if (!CollectionUtil.isNonEmpty(e)) continue;
            return e;
        }
        return (E)Collections.emptyList();
    }

    public static boolean isNonEmpty(Collection collection) {
        return collection != null && collection.size() > 0;
    }

    public static boolean isNonEmpty(Map map) {
        return map != null && map.size() > 0;
    }

    public static int size(Collection collection) {
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static <E> Set<E> treeSet(E ... EArray) {
        TreeSet<E> treeSet = new TreeSet<E>();
        if (EArray != null) {
            treeSet.addAll(Arrays.asList(EArray));
        }
        return treeSet;
    }

    public static <E> Set<E> treeSet(Set<E> set, E ... EArray) {
        TreeSet<E> treeSet = new TreeSet<E>();
        treeSet.addAll(set);
        if (EArray != null) {
            treeSet.addAll(Arrays.asList(EArray));
        }
        return treeSet;
    }

    public static Set<String> caseInsensitiveSet() {
        return new TreeSet<String>(CaseInsensitiveComparator.INSTANCE);
    }

    public static Set<String> unmodifiableSet(Set<String> set, String ... stringArray) {
        return Collections.unmodifiableSet(CollectionUtil.caseInsensitiveSet(set, stringArray));
    }

    public static Set<String> unmodifiableSet(String ... stringArray) {
        return Collections.unmodifiableSet(CollectionUtil.caseInsensitiveSet(stringArray));
    }

    public static Set<String> caseInsensitiveSet(String ... stringArray) {
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        set.addAll(Arrays.asList(stringArray));
        return set;
    }

    public static Set<String> caseInsensitiveSet(Collection<String> collection) {
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        if (collection != null) {
            set.addAll(collection);
        }
        return set;
    }

    public static Set<String> caseInsensitiveSet(Set<String> set, String ... stringArray) {
        Set<String> set2 = CollectionUtil.caseInsensitiveSet();
        set2.addAll(set);
        set2.addAll(Arrays.asList(stringArray));
        return set2;
    }

    public static <E> List<E> arrayList(List<E> list) {
        return new ArrayList<E>(list);
    }

    public static <E> List<E> sizedArrayList(int n) {
        return new ArrayList(n);
    }

    public static <E> List<E> arrayList() {
        return new ArrayList();
    }

    public static <E> List<E> arrayList(E ... EArray) {
        ArrayList<E> arrayList = new ArrayList<E>(EArray.length);
        arrayList.addAll(Arrays.asList(EArray));
        return arrayList;
    }

    public static <E> List<E> readOnlyList(E ... EArray) {
        return Collections.unmodifiableList(CollectionUtil.arrayList(EArray));
    }

    public static String[] removeElement(String[] stringArray, String string) {
        if (stringArray == null) {
            return stringArray;
        }
        if (string == null) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string2 : stringArray) {
            if (string2.equalsIgnoreCase(string)) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[0]);
    }

    public static void replaceElement(String[] stringArray, String string, String string2) {
        if (stringArray == null || string == null || string2 == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            stringArray[i] = string2;
            return;
        }
    }

    public static boolean containsAny(Set<String> set, Set<String> set2) {
        return set2.stream().anyMatch(string -> set.contains(string));
    }
}

