/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.util.ArrayList;
import java.util.List;
import workbench.util.LineParser;
import workbench.util.QuoteEscapeType;
import workbench.util.StringUtil;

public class CsvLineParser
implements LineParser {
    private String lineData = null;
    private int len = 0;
    private int current = 0;
    private String delimiter = "\t";
    private int delimiterLength;
    private char quoteChar = '\u0000';
    private boolean returnEmptyStrings = false;
    private boolean trimValues = false;
    private boolean oneMore = false;
    private QuoteEscapeType escapeType = QuoteEscapeType.none;
    private boolean unquotedEmptyIsNull = false;

    public CsvLineParser(char c) {
        this.delimiter = String.valueOf(c);
        this.delimiterLength = 1;
    }

    public CsvLineParser(char c, char c2) {
        this.delimiter = String.valueOf(c);
        this.delimiterLength = 1;
        this.quoteChar = c2;
    }

    public CsvLineParser(String string) {
        this.delimiter = string;
        this.delimiterLength = this.delimiter.length();
    }

    public CsvLineParser(String string, char c) {
        if (string != null) {
            this.delimiter = string;
            this.delimiterLength = this.delimiter.length();
        }
        this.quoteChar = c;
    }

    public QuoteEscapeType getEscapeType() {
        return this.escapeType;
    }

    public char getQuoteChar() {
        return this.quoteChar;
    }

    @Override
    public void setLine(String string) {
        this.lineData = string;
        this.len = this.lineData.length();
        this.current = 0;
    }

    public void setUnquotedEmptyStringIsNull(boolean bl) {
        this.unquotedEmptyIsNull = bl;
        if (bl) {
            this.returnEmptyStrings = false;
        }
    }

    private boolean isDelimiter(char c, int n) {
        if (this.delimiterLength == 1) {
            return c == this.delimiter.charAt(0);
        }
        if (c == this.delimiter.charAt(0)) {
            for (int i = 1; i < this.delimiterLength; ++i) {
                if (i + n < this.lineData.length()) {
                    if (this.delimiter.charAt(i) == this.lineData.charAt(n + 1)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void setReturnEmptyStrings(boolean bl) {
        this.returnEmptyStrings = bl;
    }

    public void setQuoteEscaping(QuoteEscapeType quoteEscapeType) {
        this.escapeType = quoteEscapeType;
    }

    @Override
    public boolean hasNext() {
        return this.oneMore || this.current < this.len;
    }

    @Override
    public String getNext() {
        if (this.oneMore) {
            this.oneMore = false;
            if (this.returnEmptyStrings) {
                return "";
            }
            return null;
        }
        int n = this.current;
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = false;
        while (this.current < this.len) {
            char c = this.lineData.charAt(this.current);
            if (!bl && this.isDelimiter(c, this.current)) break;
            if (c == this.quoteChar) {
                char c2;
                bl2 = true;
                if (this.escapeType == QuoteEscapeType.escape) {
                    c2 = '\u0000';
                    if (this.current > 1) {
                        c2 = this.lineData.charAt(this.current - 1);
                    }
                    if (c2 != '\\') {
                        bl = !bl;
                    }
                } else if (this.escapeType == QuoteEscapeType.duplicate && n2 == 1) {
                    c2 = '\u0000';
                    if (this.current < this.lineData.length() - 1) {
                        c2 = this.lineData.charAt(this.current + 1);
                    }
                    if (c2 == this.quoteChar) {
                        ++this.current;
                    } else {
                        bl = !bl;
                    }
                } else {
                    boolean bl3 = bl = !bl;
                }
                if (this.current == n) {
                    ++n;
                    n2 = 1;
                }
            }
            ++this.current;
        }
        String string = null;
        if (this.current - n2 > n) {
            string = this.lineData.substring(n, this.current - n2);
        }
        this.current += this.delimiterLength;
        if (this.current == this.len && this.isDelimiter(this.lineData.charAt(this.current - this.delimiterLength), this.current - this.delimiterLength)) {
            this.oneMore = true;
        }
        if (bl2 && string != null) {
            if (this.escapeType == QuoteEscapeType.escape) {
                String string2 = new String(new char[]{this.quoteChar});
                string = StringUtil.replace(string, "\\" + this.quoteChar, string2);
            } else if (this.escapeType == QuoteEscapeType.duplicate) {
                String string3 = new String(new char[]{this.quoteChar, this.quoteChar});
                String string4 = new String(new char[]{this.quoteChar});
                string = StringUtil.replace(string, string3, string4);
            }
        }
        if (bl2 && this.unquotedEmptyIsNull && string == null) {
            return "";
        }
        if (this.returnEmptyStrings && string == null) {
            string = "";
        }
        if (this.trimValues && string != null) {
            return string.trim();
        }
        return string;
    }

    @Override
    public void setTrimValues(boolean bl) {
        this.trimValues = bl;
    }

    public List<String> getAllElements() {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (this.hasNext()) {
            arrayList.add(this.getNext());
        }
        return arrayList;
    }
}

