/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import workbench.util.QuoteEscapeType;
import workbench.util.StringUtil;

public class CsvLineReader
implements Closeable {
    private final BufferedReader reader;
    private final char quoteChar;
    private final QuoteEscapeType escapeType;
    private final boolean enableMultiline;
    private final String lineEnd;
    private boolean ignoreEmptyLines;

    public CsvLineReader(BufferedReader bufferedReader, char c, QuoteEscapeType quoteEscapeType, boolean bl, String string) {
        this.reader = bufferedReader;
        this.quoteChar = c;
        this.escapeType = quoteEscapeType;
        this.enableMultiline = bl;
        this.lineEnd = string == null ? StringUtil.LINE_TERMINATOR : string;
    }

    public boolean isIgnoreEmptyLines() {
        return this.ignoreEmptyLines;
    }

    public void setIgnoreEmptyLines(boolean bl) {
        this.ignoreEmptyLines = bl;
    }

    public String readLine() throws IOException {
        String string = this.readNextLine();
        if (this.ignoreEmptyLines && StringUtil.isEmptyString(string)) {
            while (string != null && StringUtil.isEmptyString(string)) {
                string = this.readNextLine();
            }
        }
        return string;
    }

    private String readNextLine() throws IOException {
        String string = this.reader.readLine();
        if (this.enableMultiline && StringUtil.hasOpenQuotes(string, this.quoteChar, this.escapeType)) {
            string = this.readContinuationLines(string, this.quoteChar, this.escapeType);
        }
        return string;
    }

    private String readContinuationLines(String string, char c, QuoteEscapeType quoteEscapeType) throws IOException {
        String string2;
        String string3;
        String string4 = string3 = string == null ? "" : string;
        while (StringUtil.hasOpenQuotes(string3, c, quoteEscapeType) && (string2 = this.reader.readLine()) != null) {
            if (string2 == null) continue;
            string3 = string3 + this.lineEnd + string2;
        }
        return string3.trim();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

