/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.util.Set;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.sql.parser.ParserType;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class DdlObjectInfo {
    private String objectType;
    private String objectName;

    public DdlObjectInfo(CharSequence charSequence) {
        this.parseSQL(charSequence, ParserType.Standard);
    }

    public DdlObjectInfo(CharSequence charSequence, ParserType parserType) {
        this.parseSQL(charSequence, parserType);
    }

    public DdlObjectInfo(CharSequence charSequence, WbConnection wbConnection) {
        this.parseSQL(charSequence, wbConnection);
    }

    public String toString() {
        return "Type: " + this.objectType + ", name: " + this.objectName;
    }

    public void setObjectType(String string) {
        this.objectType = string;
    }

    public String getDisplayType() {
        return StringUtil.capitalize(this.objectType);
    }

    public boolean isValid() {
        return this.objectType != null;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getObjectName() {
        return this.objectName;
    }

    private void parseSQL(CharSequence charSequence, WbConnection wbConnection) {
        ParserType parserType = ParserType.getTypeFromConnection(wbConnection);
        this.parseSQL(charSequence, parserType);
    }

    private void parseSQL(CharSequence charSequence, ParserType parserType) {
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(parserType, charSequence);
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        if (sQLToken == null) {
            return;
        }
        String string = sQLToken.getContents();
        Set<String> set = CollectionUtil.caseInsensitiveSet("DROP", "RECREATE", "ALTER", "ANALYZE");
        if (!string.startsWith("CREATE") && !set.contains(string)) {
            return;
        }
        try {
            Object object;
            boolean bl = false;
            SQLToken sQLToken2 = sQLLexer.getNextToken(false, false);
            while (sQLToken2 != null) {
                object = sQLToken2.getContents();
                if (SqlUtil.getKnownTypes().contains(object)) {
                    bl = true;
                    this.objectType = ((String)object).toUpperCase();
                    break;
                }
                sQLToken2 = sQLLexer.getNextToken(false, false);
            }
            if (!bl) {
                return;
            }
            if (!SqlUtil.getTypesWithoutNames().contains(this.objectType)) {
                object = sQLLexer.getNextToken(false, false);
                if (object == null) {
                    return;
                }
                String string2 = ((SQLToken)object).getContents();
                if ((string2.equals("IF NOT EXISTS") || string2.equals("IF EXISTS") || string2.equals("EDITIONABLE")) && (object = sQLLexer.getNextToken(false, false)) == null) {
                    return;
                }
                SQLToken sQLToken3 = sQLLexer.getNextToken(false, false);
                if (sQLToken3 != null && sQLToken3.getContents().equals(".") && (sQLToken3 = sQLLexer.getNextToken(false, false)) != null) {
                    object = sQLToken3;
                }
                this.objectName = this.objectType.equalsIgnoreCase("index") && ((SQLToken)object).getContents().equals("ON") ? null : (sQLToken3 != null && ((SQLToken)object).getContents().endsWith(".") ? SqlUtil.removeObjectQuotes(((SQLToken)object).getContents()) + SqlUtil.removeObjectQuotes(sQLToken3.getContents()) : SqlUtil.removeObjectQuotes(((SQLToken)object).getContents()));
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error finding object info", exception);
            this.objectName = null;
            this.objectType = null;
        }
    }
}

