/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import workbench.resource.Settings;
import workbench.util.DurationFormat;

public class DurationFormatter {
    private final DecimalFormat numberFormatter;
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;

    public DurationFormatter() {
        this.numberFormatter = DurationFormatter.createTimingFormatter();
    }

    public DurationFormatter(char c) {
        this.numberFormatter = DurationFormatter.createTimingFormatter(c);
    }

    public static DecimalFormat createTimingFormatter(char c) {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator(c);
        DecimalFormat decimalFormat = new DecimalFormat("0.#s", decimalFormatSymbols);
        decimalFormat.setMaximumFractionDigits(2);
        return decimalFormat;
    }

    public static DecimalFormat createTimingFormatter() {
        String string = Settings.getInstance().getProperty("workbench.log.timing.decimal", ".");
        return DurationFormatter.createTimingFormatter(string.charAt(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDurationAsSeconds(long l) {
        double d = (double)l / 1000.0;
        DecimalFormat decimalFormat = this.numberFormatter;
        synchronized (decimalFormat) {
            return this.numberFormatter.format(d);
        }
    }

    public String formatDuration(long l) {
        return this.formatDuration(l, DurationFormat.dynamic, l < 60000L, true);
    }

    public String formatDuration(long l, DurationFormat durationFormat, boolean bl) {
        return this.formatDuration(l, durationFormat, bl, true);
    }

    public String formatDuration(long l, DurationFormat durationFormat, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(20);
        if (durationFormat == DurationFormat.millis) {
            stringBuilder.append(Long.toString(l));
            stringBuilder.append("ms");
        } else if (durationFormat == DurationFormat.seconds) {
            stringBuilder.append(this.getDurationAsSeconds(l));
        } else {
            long l2 = l / 3600000L;
            long l3 = (l -= l2 * 3600000L) / 60000L;
            l -= l3 * 60000L;
            if (l2 > 0L) {
                stringBuilder.append(l2);
                stringBuilder.append("h ");
            }
            if (l3 == 0L && l2 > 0L || l3 > 0L) {
                stringBuilder.append(l3);
                stringBuilder.append("m ");
            }
            if (bl) {
                stringBuilder.append(this.getDurationAsSeconds(l));
            } else {
                int n = (int)l / 1000;
                if (n > 0 || bl2) {
                    stringBuilder.append(Long.toString(n));
                    stringBuilder.append('s');
                }
            }
        }
        return stringBuilder.toString().trim();
    }
}

