/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import workbench.util.StringUtil;

public class DurationNumber {
    private final char UNIT_SECONDS = (char)115;
    private final char UNIT_MINUTES = (char)109;
    private final char UNIT_HOURS = (char)104;
    private final char UNIT_DAYS = (char)100;
    private final long ONE_SECOND = 1000L;
    private final long ONE_MINUTE = 60000L;
    private final long ONE_HOUR = 3600000L;
    private final long ONE_DAY = 86400000L;

    public boolean isValid(String string) {
        if (StringUtil.isBlank(string)) {
            return false;
        }
        String string2 = "^[0-9]+[smhd]{1}$";
        return string.trim().toLowerCase().matches(string2);
    }

    public long parseDefinition(String string) {
        if (StringUtil.isEmptyString(string)) {
            return 0L;
        }
        if ((string = string.trim().toLowerCase().replace(" ", "")).isEmpty()) {
            return 0L;
        }
        if (string.length() == 1) {
            return StringUtil.getLongValue(string, 0L);
        }
        char c = string.charAt(string.length() - 1);
        long l = -1L;
        l = Character.isDigit(c) ? StringUtil.getLongValue(string, 0L) : StringUtil.getLongValue(string.substring(0, string.length() - 1), 0L);
        switch (c) {
            case 's': {
                return l * 1000L;
            }
            case 'm': {
                return l * 60000L;
            }
            case 'h': {
                return l * 3600000L;
            }
            case 'd': {
                return l * 86400000L;
            }
        }
        return l;
    }
}

