/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.util.ArrayList;
import java.util.List;
import workbench.interfaces.EventDisplay;
import workbench.util.NotifierEvent;

public class EventNotifier {
    private final List<EventDisplay> displayClients = new ArrayList<EventDisplay>(1);
    private NotifierEvent lastEvent = null;
    private static final EventNotifier INSTANCE = new EventNotifier();

    private EventNotifier() {
    }

    public static EventNotifier getInstance() {
        return INSTANCE;
    }

    public synchronized void addEventDisplay(EventDisplay eventDisplay) {
        this.displayClients.add(eventDisplay);
        if (this.lastEvent != null) {
            eventDisplay.showAlert(this.lastEvent);
        }
    }

    public synchronized void removeEventDisplay(EventDisplay eventDisplay) {
        this.displayClients.remove(eventDisplay);
    }

    public synchronized void displayNotification(NotifierEvent notifierEvent) {
        this.lastEvent = notifierEvent;
        for (EventDisplay eventDisplay : this.displayClients) {
            eventDisplay.showAlert(notifierEvent);
        }
    }

    public synchronized void removeNotification() {
        for (EventDisplay eventDisplay : this.displayClients) {
            eventDisplay.removeAlert();
        }
    }
}

