/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.PlatformHelper;

public class FileAttributeChanger {
    public void removeHidden(File file) {
        if (PlatformHelper.isWindows()) {
            this.removeAttribute(file);
        }
    }

    private void removeAttribute(File file) {
        try {
            Path path = file.toPath();
            Files.setAttribute(path, "dos:hidden", false, LinkOption.NOFOLLOW_LINKS);
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not remove hidden attribute of config dir: " + file.getAbsolutePath(), throwable);
        }
    }
}

