/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import workbench.interfaces.CharacterSequence;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.FileUtil;

public class FileMappedSequence
implements CharacterSequence {
    private int chunkSize;
    private String chunk;
    private CharsetDecoder decoder;
    private int chunkByteStart = -1;
    private int chunkCharStart;
    private long fileSize;
    private long charLength;
    private FileInputStream input;
    private FileChannel channel;
    private ByteBuffer readBuffer;
    private int increasedChunkSize = -1;

    public FileMappedSequence(File file, String string) throws IOException {
        this(file, string, 524288);
    }

    public FileMappedSequence(File file, String string, int n) throws IOException {
        this.chunkSize = n;
        this.init(file, string);
        this.readFirstChunk();
    }

    private void init(File file, String string) throws IOException {
        this.fileSize = file.length();
        this.charLength = string.toLowerCase().startsWith("utf") ? FileUtil.getCharacterLength(file, string) : this.fileSize;
        this.input = new FileInputStream(file);
        this.channel = this.input.getChannel();
        this.chunk = "";
        this.readBuffer = ByteBuffer.allocateDirect(this.chunkSize);
        Charset charset = Charset.forName(string);
        this.decoder = charset.newDecoder();
    }

    @Override
    public int length() {
        return (int)this.charLength;
    }

    final void readFirstChunk() {
        this.chunkByteStart = -1;
        this.readNextChunk();
    }

    final void readNextChunk() {
        int n;
        boolean bl = false;
        int n2 = 0;
        int n3 = this.chunkCharStart + this.chunk.length();
        int n4 = this.increasedChunkSize <= 0 ? this.chunkSize : this.increasedChunkSize;
        this.increasedChunkSize = -1;
        int n5 = n = this.chunkByteStart == -1 ? 0 : this.chunkByteStart + this.chunkSize;
        while (!bl) {
            try {
                this._readChunk(n, n4);
                bl = true;
                this.chunkCharStart = n3;
                this.chunkSize = n4;
                this.chunkByteStart = n;
            }
            catch (CharacterCodingException characterCodingException) {
                if (++n2 > 3) {
                    LogMgr.logError(new CallerInfo(){}, "Error reading file", characterCodingException);
                    throw new IllegalStateException("Could not read next chunk");
                }
                ++n4;
            }
            catch (IOException iOException) {
                LogMgr.logError(new CallerInfo(){}, "Error reading file", iOException);
                throw new IllegalStateException("Could not read next chunk");
            }
        }
    }

    void readPreviousChunk() {
        if (this.chunkByteStart == 0) {
            return;
        }
        int n = this.chunkByteStart - this.chunkSize;
        int n2 = this.chunkSize;
        int n3 = this.chunkCharStart;
        if (n < 0) {
            n = 0;
        }
        int n4 = 0;
        boolean bl = false;
        while (!bl) {
            try {
                this._readChunk(n, n2);
                bl = true;
                this.chunkSize = n2;
                this.chunkByteStart = n;
                this.chunkCharStart = n > 0 ? n3 - this.chunk.length() : 0;
            }
            catch (IOException iOException) {
                if (++n4 > 3) {
                    LogMgr.logError(new CallerInfo(){}, "Error when reading chunk from: " + n + " with size: " + this.chunkSize, iOException);
                    throw new IllegalStateException("Could not read previous chunk");
                }
                if (n > 0) {
                    --n;
                }
                ++n2;
            }
        }
    }

    private void _readChunk(int n, int n2) throws CharacterCodingException, IOException {
        if (n2 > this.readBuffer.capacity()) {
            this.readBuffer = ByteBuffer.allocateDirect(n2);
        }
        if ((long)(n + n2) > this.fileSize) {
            this.chunkSize = (int)(this.fileSize - (long)n);
        }
        this.readBuffer.clear();
        this.readBuffer.limit(n2);
        int n3 = this.channel.read(this.readBuffer, n);
        if (n3 == -1) {
            return;
        }
        this.readBuffer.rewind();
        this.readBuffer.limit(n3);
        CharBuffer charBuffer = this.decoder.decode(this.readBuffer);
        this.chunk = charBuffer.toString();
    }

    @Override
    public void done() {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error closing input stream", exception);
        }
    }

    public int getCurrentChunkLength() {
        return this.chunk.length();
    }

    @Override
    public char charAt(int n) {
        if ((long)n > this.charLength || n < 0) {
            throw new StringIndexOutOfBoundsException(n + " > " + this.charLength);
        }
        int n2 = this.chunk.length();
        if (n >= this.chunkCharStart + n2) {
            while (n >= this.chunkCharStart + n2) {
                this.readNextChunk();
            }
        } else if (n < this.chunkCharStart) {
            while (n < this.chunkCharStart) {
                this.readPreviousChunk();
            }
        }
        int n3 = n - this.chunkCharStart;
        return this.chunk.charAt(n3);
    }

    @Override
    public String subSequence(int n, int n2) {
        if ((long)n2 > this.charLength) {
            throw new StringIndexOutOfBoundsException(n2 + " > " + this.charLength);
        }
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n2 + " > " + this.charLength);
        }
        this.charAt(n);
        int n3 = n - this.chunkCharStart;
        int n4 = n2 - n;
        int n5 = n3 + n4;
        if (n5 < this.chunk.length()) {
            return this.chunk.substring(n3, n5);
        }
        StringBuilder stringBuilder = new StringBuilder(n4);
        stringBuilder.append(this.chunk.substring(n3));
        int n6 = n + stringBuilder.length();
        stringBuilder.append(this.subSequence(n6, n2));
        return stringBuilder.toString();
    }
}

