/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.util.List;
import workbench.RunMode;
import workbench.WbManager;
import workbench.console.WbConsole;
import workbench.console.WbConsoleFactory;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.gui.components.MasterPwdInputForm;
import workbench.gui.components.ValidatingDialog;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.ssh.SshConfigMgr;
import workbench.ssh.SshHostConfig;
import workbench.util.StringUtil;
import workbench.util.WbAESCipher;
import workbench.util.WbCipher;
import workbench.util.WbDesCipher;

public class GlobalPasswordManager {
    private WbAESCipher masterCipher;

    public static final GlobalPasswordManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private GlobalPasswordManager() {
    }

    public String encrypt(String string) {
        if (StringUtil.isEmptyString(string)) {
            return string;
        }
        if (this.masterCipher == null) {
            return string;
        }
        return this.masterCipher.encryptString(string);
    }

    public String decrypt(String string) {
        if (StringUtil.isEmptyString(string)) {
            return string;
        }
        if (!Settings.getInstance().getUseMasterPassword()) {
            return string;
        }
        this.initCipher();
        return this.masterCipher.decryptString(string);
    }

    public synchronized boolean showPasswordPromptIfNeeded() {
        return this.showPasswordPrompt(false);
    }

    public synchronized void applyNewPassword(String string) {
        List<ConnectionProfile> list = ConnectionMgr.getInstance().getProfiles();
        WbAESCipher wbAESCipher = null;
        if (string != null) {
            LogMgr.logDebug(new CallerInfo(){}, "Applying new master password");
            wbAESCipher = new WbAESCipher(string);
        } else {
            LogMgr.logDebug(new CallerInfo(){}, "Removing master password");
        }
        for (ConnectionProfile connectionProfile : list) {
            Object object;
            Object object2;
            if (connectionProfile.getStorePassword()) {
                object2 = this.decryptProfilePassword(connectionProfile);
                if (wbAESCipher != null && StringUtil.isNonEmpty((CharSequence)object2)) {
                    object = wbAESCipher.encryptString((String)object2);
                    connectionProfile.setEncryptedPassword("$@wb@$" + (String)object);
                } else {
                    connectionProfile.setEncryptedPassword((String)object2);
                }
                this.adjustSshPassword(connectionProfile.getSshHostConfig(), wbAESCipher);
            }
            object2 = SshConfigMgr.getDefaultInstance().getGlobalConfigs();
            object = object2.iterator();
            while (object.hasNext()) {
                SshHostConfig sshHostConfig = (SshHostConfig)object.next();
                this.adjustSshPassword(sshHostConfig, wbAESCipher);
            }
        }
        this.masterCipher = wbAESCipher;
        if (this.masterCipher != null) {
            Settings.getInstance().setEncryptedMasterPassword(this.masterCipher.encryptString(string));
        } else {
            Settings.getInstance().setEncryptedMasterPassword(null);
        }
    }

    private void adjustSshPassword(SshHostConfig sshHostConfig, WbAESCipher wbAESCipher) {
        if (sshHostConfig == null) {
            return;
        }
        String string = sshHostConfig.getDecryptedPassword();
        if (wbAESCipher != null && StringUtil.isNonEmpty(string)) {
            String string2 = wbAESCipher.encryptString(string);
            sshHostConfig.setPassword("$@wb@$" + string2);
        } else {
            sshHostConfig.setPassword(string);
        }
    }

    private String decryptProfilePassword(ConnectionProfile connectionProfile) {
        String string = connectionProfile.getPassword();
        if (StringUtil.isEmptyString(string)) {
            return string;
        }
        if (string.startsWith("@*@")) {
            WbCipher wbCipher = WbDesCipher.getInstance();
            return wbCipher.decryptString(string.substring("@*@".length()));
        }
        if (string.startsWith("$@wb@$") && this.masterCipher != null) {
            return this.masterCipher.decryptString(string.substring("$@wb@$".length()));
        }
        return string;
    }

    public synchronized boolean showPasswordPrompt(boolean bl) {
        if (Settings.getInstance().getUseMasterPassword() && (bl || this.masterCipher == null)) {
            return this.promptForPassword();
        }
        return true;
    }

    private void initCipher() {
        if (this.masterCipher != null) {
            return;
        }
        this.showPasswordPrompt(false);
    }

    private boolean promptForPassword() {
        this.masterCipher = null;
        boolean bl = false;
        if (WbManager.getInstance().getRunMode() == RunMode.GUI) {
            MasterPwdInputForm masterPwdInputForm = new MasterPwdInputForm(this);
            bl = ValidatingDialog.showConfirmDialog(WbManager.getInstance().getCurrentWindow(), masterPwdInputForm, ResourceMgr.getString("LblMasterPwd"));
        } else {
            bl = this.doConsolePrompt();
        }
        return bl;
    }

    private boolean doConsolePrompt() {
        String string = ResourceMgr.getString("MsgEnterMasterPwd");
        WbConsole wbConsole = WbConsoleFactory.getConsole();
        while (true) {
            String string2;
            if (StringUtil.isBlank(string2 = wbConsole.readPassword(string + ": "))) {
                return false;
            }
            if (this.validateMasterPassword(string2)) break;
            System.out.println(ResourceMgr.getString("MsgWrongPassword"));
        }
        return true;
    }

    public boolean validateMasterPassword(String string) {
        String string2 = Settings.getInstance().getEncryptedMasterPassword();
        if (string2 == null) {
            return false;
        }
        WbAESCipher wbAESCipher = new WbAESCipher(string);
        String string3 = wbAESCipher.encryptString(string);
        boolean bl = string2.equals(string3);
        this.masterCipher = bl ? wbAESCipher : null;
        return bl;
    }

    private static class InstanceHolder {
        private static final GlobalPasswordManager INSTANCE = new GlobalPasswordManager();

        private InstanceHolder() {
        }
    }
}

