/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import workbench.util.NumberStringCache;

public class HtmlUtil {
    private static final int MIN_ESCAPE = 2;
    private static final int MAX_ESCAPE = 6;
    private static final Map<String, String> ESCAPES = new HashMap<String, String>(){
        {
            this.put("quot", "\"");
            this.put("amp", "&");
            this.put("lt", "<");
            this.put("gt", ">");
            this.put("nbsp", "\u00a0");
            this.put("iexcl", "\u00a1");
            this.put("cent", "\u00a2");
            this.put("pound", "\u00a3");
            this.put("curren", "\u00a4");
            this.put("yen", "\u00a5");
            this.put("brvbar", "\u00a6");
            this.put("sect", "\u00a7");
            this.put("uml", "\u00a8");
            this.put("copy", "\u00a9");
            this.put("ordf", "\u00aa");
            this.put("laquo", "\u00ab");
            this.put("not", "\u00ac");
            this.put("shy", "\u00ad");
            this.put("reg", "\u00ae");
            this.put("macr", "\u00af");
            this.put("deg", "\u00b0");
            this.put("plusmn", "\u00b1");
            this.put("sup2", "\u00b2");
            this.put("sup3", "\u00b3");
            this.put("acute", "\u00b4");
            this.put("micro", "\u00b5");
            this.put("para", "\u00b6");
            this.put("middot", "\u00b7");
            this.put("cedil", "\u00b8");
            this.put("sup1", "\u00b9");
            this.put("ordm", "\u00ba");
            this.put("raquo", "\u00bb");
            this.put("frac14", "\u00bc");
            this.put("frac12", "\u00bd");
            this.put("frac34", "\u00be");
            this.put("iquest", "\u00bf");
            this.put("Agrave", "\u00c0");
            this.put("Aacute", "\u00c1");
            this.put("Acirc", "\u00c2");
            this.put("Atilde", "\u00c3");
            this.put("Auml", "\u00c4");
            this.put("Aring", "\u00c5");
            this.put("AElig", "\u00c6");
            this.put("Ccedil", "\u00c7");
            this.put("Egrave", "\u00c8");
            this.put("Eacute", "\u00c9");
            this.put("Ecirc", "\u00ca");
            this.put("Euml", "\u00cb");
            this.put("Igrave", "\u00cc");
            this.put("Iacute", "\u00cd");
            this.put("Icirc", "\u00ce");
            this.put("Iuml", "\u00cf");
            this.put("ETH", "\u00d0");
            this.put("Ntilde", "\u00d1");
            this.put("Ograve", "\u00d2");
            this.put("Oacute", "\u00d3");
            this.put("Ocirc", "\u00d4");
            this.put("Otilde", "\u00d5");
            this.put("Ouml", "\u00d6");
            this.put("times", "\u00d7");
            this.put("Oslash", "\u00d8");
            this.put("Ugrave", "\u00d9");
            this.put("Uacute", "\u00da");
            this.put("Ucirc", "\u00db");
            this.put("Uuml", "\u00dc");
            this.put("Yacute", "\u00dd");
            this.put("THORN", "\u00de");
            this.put("szlig", "\u00df");
            this.put("agrave", "\u00e0");
            this.put("aacute", "\u00e1");
            this.put("acirc", "\u00e2");
            this.put("atilde", "\u00e3");
            this.put("auml", "\u00e4");
            this.put("aring", "\u00e5");
            this.put("aelig", "\u00e6");
            this.put("ccedil", "\u00e7");
            this.put("egrave", "\u00e8");
            this.put("eacute", "\u00e9");
            this.put("ecirc", "\u00ea");
            this.put("euml", "\u00eb");
            this.put("igrave", "\u00ec");
            this.put("iacute", "\u00ed");
            this.put("icirc", "\u00ee");
            this.put("iuml", "\u00ef");
            this.put("eth", "\u00f0");
            this.put("ntilde", "\u00f1");
            this.put("ograve", "\u00f2");
            this.put("oacute", "\u00f3");
            this.put("ocirc", "\u00f4");
            this.put("otilde", "\u00f5");
            this.put("ouml", "\u00f6");
            this.put("divide", "\u00f7");
            this.put("oslash", "\u00f8");
            this.put("ugrave", "\u00f9");
            this.put("uacute", "\u00fa");
            this.put("ucirc", "\u00fb");
            this.put("uuml", "\u00fc");
            this.put("yacute", "\u00fd");
            this.put("thorn", "\u00fe");
            this.put("yuml", "\u00ff");
        }
    };

    public static String escapeXML(CharSequence charSequence) {
        return HtmlUtil.escapeXML(charSequence, true);
    }

    public static String escapeXML(CharSequence charSequence, boolean bl) {
        if (charSequence == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence.length() + 100);
        int n = charSequence.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (c < ' ') {
                stringBuilder.append("&#");
                stringBuilder.append(NumberStringCache.getNumberString(c));
                stringBuilder.append(';');
                continue;
            }
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    if (bl) {
                        stringBuilder.append("&apos;");
                        continue block7;
                    }
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String escapeHTML(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 100);
        int n = string.length();
        block45: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block45;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block45;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block45;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block45;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block45;
                }
                case '\u00e0': {
                    stringBuilder.append("&agrave;");
                    continue block45;
                }
                case '\u00c0': {
                    stringBuilder.append("&Agrave;");
                    continue block45;
                }
                case '\u00e2': {
                    stringBuilder.append("&acirc;");
                    continue block45;
                }
                case '\u00c2': {
                    stringBuilder.append("&Acirc;");
                    continue block45;
                }
                case '\u00e4': {
                    stringBuilder.append("&auml;");
                    continue block45;
                }
                case '\u00c4': {
                    stringBuilder.append("&Auml;");
                    continue block45;
                }
                case '\u00e5': {
                    stringBuilder.append("&aring;");
                    continue block45;
                }
                case '\u00c5': {
                    stringBuilder.append("&Aring;");
                    continue block45;
                }
                case '\u00e6': {
                    stringBuilder.append("&aelig;");
                    continue block45;
                }
                case '\u00c6': {
                    stringBuilder.append("&AElig;");
                    continue block45;
                }
                case '\u00e7': {
                    stringBuilder.append("&ccedil;");
                    continue block45;
                }
                case '\u00c7': {
                    stringBuilder.append("&Ccedil;");
                    continue block45;
                }
                case '\u00e9': {
                    stringBuilder.append("&eacute;");
                    continue block45;
                }
                case '\u00c9': {
                    stringBuilder.append("&Eacute;");
                    continue block45;
                }
                case '\u00e8': {
                    stringBuilder.append("&egrave;");
                    continue block45;
                }
                case '\u00c8': {
                    stringBuilder.append("&Egrave;");
                    continue block45;
                }
                case '\u00ea': {
                    stringBuilder.append("&ecirc;");
                    continue block45;
                }
                case '\u00ca': {
                    stringBuilder.append("&Ecirc;");
                    continue block45;
                }
                case '\u00eb': {
                    stringBuilder.append("&euml;");
                    continue block45;
                }
                case '\u00cb': {
                    stringBuilder.append("&Euml;");
                    continue block45;
                }
                case '\u00ef': {
                    stringBuilder.append("&iuml;");
                    continue block45;
                }
                case '\u00cf': {
                    stringBuilder.append("&Iuml;");
                    continue block45;
                }
                case '\u00f4': {
                    stringBuilder.append("&ocirc;");
                    continue block45;
                }
                case '\u00d4': {
                    stringBuilder.append("&Ocirc;");
                    continue block45;
                }
                case '\u00f6': {
                    stringBuilder.append("&ouml;");
                    continue block45;
                }
                case '\u00d6': {
                    stringBuilder.append("&Ouml;");
                    continue block45;
                }
                case '\u00f8': {
                    stringBuilder.append("&oslash;");
                    continue block45;
                }
                case '\u00d8': {
                    stringBuilder.append("&Oslash;");
                    continue block45;
                }
                case '\u00df': {
                    stringBuilder.append("&szlig;");
                    continue block45;
                }
                case '\u00f9': {
                    stringBuilder.append("&ugrave;");
                    continue block45;
                }
                case '\u00d9': {
                    stringBuilder.append("&Ugrave;");
                    continue block45;
                }
                case '\u00fb': {
                    stringBuilder.append("&ucirc;");
                    continue block45;
                }
                case '\u00db': {
                    stringBuilder.append("&Ucirc;");
                    continue block45;
                }
                case '\u00fc': {
                    stringBuilder.append("&uuml;");
                    continue block45;
                }
                case '\u00dc': {
                    stringBuilder.append("&Uuml;");
                    continue block45;
                }
                case '\u00ae': {
                    stringBuilder.append("&reg;");
                    continue block45;
                }
                case '\u00a9': {
                    stringBuilder.append("&copy;");
                    continue block45;
                }
                case '\u20ac': {
                    stringBuilder.append("&euro;");
                    continue block45;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static final String unescapeHTML(String string) {
        StringWriter stringWriter = null;
        int n = string.length();
        int n2 = 1;
        int n3 = 0;
        while (true) {
            int n4;
            block14: {
                if (n2 < n && string.charAt(n2 - 1) != '&') {
                    ++n2;
                    continue;
                }
                if (n2 >= n) break;
                for (n4 = n2; n4 < n && n4 < n2 + 6 + 1 && string.charAt(n4) != ';'; ++n4) {
                }
                if (n4 == n || n4 < n2 + 2 || n4 == n2 + 6 + 1) {
                    ++n2;
                    continue;
                }
                if (string.charAt(n2) == '#') {
                    int n5 = n2 + 1;
                    int n6 = 10;
                    char c = string.charAt(n5);
                    if (c == 'x' || c == 'X') {
                        ++n5;
                        n6 = 16;
                    }
                    try {
                        int n7 = Integer.parseInt(string.substring(n5, n4), n6);
                        if (stringWriter == null) {
                            stringWriter = new StringWriter(string.length());
                        }
                        stringWriter.append(string.substring(n3, n2 - 1));
                        if (n7 > 65535) {
                            char[] cArray = Character.toChars(n7);
                            stringWriter.write(cArray[0]);
                            stringWriter.write(cArray[1]);
                        } else {
                            stringWriter.write(n7);
                        }
                        break block14;
                    }
                    catch (NumberFormatException numberFormatException) {
                        ++n2;
                        continue;
                    }
                }
                String string2 = string.substring(n2, n4);
                CharSequence charSequence = ESCAPES.get(string2);
                if (charSequence == null) {
                    ++n2;
                    continue;
                }
                if (stringWriter == null) {
                    stringWriter = new StringWriter(string.length());
                }
                stringWriter.append(string.substring(n3, n2 - 1));
                stringWriter.append(charSequence);
            }
            n2 = n3 = n4 + 1;
        }
        if (stringWriter != null) {
            stringWriter.append(string.substring(n3, n));
            return stringWriter.toString();
        }
        return string;
    }

    public static String cleanHTML(String string) {
        if (string == null) {
            return string;
        }
        return string.replaceAll("\\<.*?\\>", "");
    }

    public static String convertToMultiline(String string) {
        return string.replaceAll("((\r\n)|(\n\r)|\r|\n)", "<br>");
    }
}

