/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.awt.EventQueue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import workbench.WbManager;
import workbench.gui.actions.OptionsDialogAction;
import workbench.gui.dialogs.WbAboutDialog;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;

public class MacOSHelper
implements InvocationHandler {
    private Object proxy;
    private static boolean isMacOS = System.getProperty("os.name").startsWith("Mac OS");

    public static boolean isMacOS() {
        return isMacOS;
    }

    public void installApplicationHandler() {
        if (!MacOSHelper.isMacOS()) {
            return;
        }
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            LogMgr.logDebug(callerInfo, "Trying to install Mac OS ApplicationListener");
            Class<?> clazz = Class.forName("com.apple.eawt.Application");
            Object obj = clazz.newInstance();
            if (obj != null) {
                LogMgr.logDebug(callerInfo, "Obtained Application object");
                Class<?> clazz2 = Class.forName("com.apple.eawt.ApplicationListener");
                this.proxy = Proxy.newProxyInstance(clazz2.getClassLoader(), new Class[]{clazz2}, (InvocationHandler)this);
                Method method = clazz.getMethod("addApplicationListener", clazz2);
                if (method != null) {
                    method.invoke(obj, this.proxy);
                    LogMgr.logInfo(callerInfo, "Mac OS ApplicationListener installed");
                }
                Method method2 = clazz.getMethod("setEnabledPreferencesMenu", Boolean.TYPE);
                method2.invoke(obj, Boolean.TRUE);
                LogMgr.logDebug(callerInfo, "Registered for Preferences event");
            } else {
                LogMgr.logError(callerInfo, "Could not create com.apple.eawt.Application", null);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(callerInfo, "Could not install ApplicationListener", exception);
        }
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        CallerInfo callerInfo = new CallerInfo(){};
        if (object != this.proxy) {
            LogMgr.logWarning(callerInfo, "Different Proxy object passed to invoke!");
        }
        try {
            String string = method.getName();
            LogMgr.logDebug(callerInfo, "ApplicationEvent [" + string + "] received. Arguments: " + this.getArguments(objectArray));
            if ("handleQuit".equals(string)) {
                WbManager.getInstance().saveConfigSettings();
                WbManager.getInstance().removeShutdownHook();
                boolean bl = Settings.getInstance().getBoolProperty("workbench.osx.quit.sethandled", true);
                if (bl) {
                    System.setProperty("workbench.system.doexit", "false");
                }
                this.setHandled(objectArray[0], bl);
                boolean bl2 = Settings.getInstance().getBoolProperty("workbench.osx.quit.immediate", true);
                if (bl2) {
                    LogMgr.logDebug(callerInfo, "Calling exitWorkbench()");
                    WbManager.getInstance().exitWorkbench(false);
                } else {
                    EventQueue.invokeLater(() -> {
                        LogMgr.logDebug(callerInfo, "Calling exitWorkbench()");
                        WbManager.getInstance().exitWorkbench(false);
                    });
                }
            } else if ("handleAbout".equals(string)) {
                WbAboutDialog.showDialog(null);
            } else if ("handlePreferences".equals(string)) {
                OptionsDialogAction.showOptionsDialog();
                this.setHandled(objectArray[0], true);
            } else {
                LogMgr.logInfo(callerInfo, "Ignoring unknown event: " + method.getName());
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(callerInfo, "Error during callback", throwable);
            LogMgr.logDebug(callerInfo, "Arguments: " + this.getArguments(objectArray));
        }
        return null;
    }

    private String getArguments(Object[] objectArray) {
        if (objectArray == null) {
            return "<null>";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("args[");
            stringBuilder.append(Integer.toString(i));
            stringBuilder.append("]=");
            if (objectArray[i] == null) {
                stringBuilder.append("null");
                continue;
            }
            stringBuilder.append(objectArray[i].getClass().getName());
            stringBuilder.append(" [");
            stringBuilder.append(objectArray[i].toString());
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    private void setHandled(Object object, boolean bl) {
        CallerInfo callerInfo = new CallerInfo(){};
        if (object == null) {
            LogMgr.logError(callerInfo, "No event object passed!", null);
            return;
        }
        try {
            Method method = object.getClass().getMethod("setHandled", Boolean.TYPE);
            LogMgr.logDebug(callerInfo, "Setting handled=" + bl + " for event: " + object.toString());
            method.invoke(object, bl);
        }
        catch (Exception exception) {
            LogMgr.logWarning(callerInfo, "Could not call setHandled() on class " + object.getClass().getName(), exception);
        }
    }
}

