/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

public class NumberStringCache {
    public static final char[] HEX_ARRAY_LOWER = "0123456789abcdef".toCharArray();
    public static final char[] HEX_ARRAY_UPPER = "0123456789ABCDEF".toCharArray();
    private final int CACHE_SIZE = 5000;
    private final String[] cache = new String[5000];
    private final String[] hexCache = new String[256];

    public static NumberStringCache getInstance() {
        return InstanceHolder.LAZY_INSTANCE;
    }

    private NumberStringCache() {
        for (int i = 0; i < 256; ++i) {
            this.hexCache[i] = this.hexString(i);
        }
    }

    public static String getHexString(int n) {
        return NumberStringCache.getInstance()._getHexString(n);
    }

    private String _getHexString(int n) {
        if (n < 0 || n > 255) {
            return Integer.toHexString(n);
        }
        return this.hexCache[n];
    }

    private String hexString(int n) {
        char[] cArray = new char[]{HEX_ARRAY_LOWER[n >>> 4], HEX_ARRAY_LOWER[n & 0xF]};
        return new String(cArray);
    }

    public static String getNumberString(long l) {
        return NumberStringCache.getInstance()._getNumberString(l);
    }

    private String _getNumberString(long l) {
        if (l < 0L || l >= 5000L) {
            return Long.toString(l);
        }
        int n = (int)l;
        if (this.cache[n] == null) {
            this.cache[n] = Integer.toString(n);
        }
        return this.cache[n];
    }

    private static class InstanceHolder {
        static final NumberStringCache LAZY_INSTANCE = new NumberStringCache();

        private InstanceHolder() {
        }
    }
}

