/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import workbench.db.TableIdentifier;
import workbench.util.Alias;
import workbench.util.StringUtil;

public class TableAlias
extends Alias {
    private TableIdentifier table;

    public TableAlias(String string) {
        super(string);
        this.checkTable('.', '.');
    }

    public TableAlias(String string, char c, char c2) {
        super(string);
        this.checkTable(c, c2);
    }

    public TableAlias(String string, String string2, char c, char c2) {
        super(string, string2);
        this.checkTable(c, c2);
    }

    private void checkTable(char c, char c2) {
        if (this.getObjectName() != null) {
            this.table = new TableIdentifier(this.getObjectName(), c, c2);
        }
    }

    public final TableIdentifier getTable() {
        return this.table;
    }

    public boolean isTableOrAlias(String string, char c, char c2) {
        if (StringUtil.isEmptyString(string)) {
            return false;
        }
        TableIdentifier tableIdentifier = new TableIdentifier(string, c, c2);
        return this.table.getTableName().equalsIgnoreCase(tableIdentifier.getTableName()) || string.equalsIgnoreCase(this.getAlias());
    }

    public static TableAlias createFrom(Alias alias) {
        TableAlias tableAlias = new TableAlias(alias.getObjectName());
        tableAlias.setAlias(alias.getAlias());
        tableAlias.setStartPositionInQuery(alias.getStartPositionInQuery());
        tableAlias.setEndPositionInQuery(alias.getEndPositionInQuery());
        return tableAlias;
    }
}

