/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class ToolDefinition {
    private String exePath;
    private String name;
    private String parameters;

    public ToolDefinition() {
    }

    public ToolDefinition(String string, String string2, String string3) {
        this.setExecutablePath(string);
        this.setName(string3);
        this.setParameters(string2);
    }

    public String getParameters() {
        return this.parameters;
    }

    public final void setParameters(String string) {
        this.parameters = string;
    }

    public String getName() {
        return this.name;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public String getExecutablePath() {
        return this.exePath;
    }

    public final void setExecutablePath(String string) {
        this.exePath = string;
    }

    public String toString() {
        return this.getName();
    }

    public WbFile getExecutable() {
        if (this.exePath == null) {
            return null;
        }
        return new WbFile(this.exePath);
    }

    public void runApplication(String string) throws IOException {
        List<String> list = this.getComandElements();
        String[] stringArray = new String[list.size() + 1];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = list.get(i);
        }
        stringArray[list.size()] = string;
        Runtime.getRuntime().exec(stringArray, null);
    }

    public boolean executableExists() {
        WbFile wbFile = this.getExecutable();
        return wbFile.exists();
    }

    private List<String> getComandElements() {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add(this.exePath);
        if (StringUtil.isNonBlank(this.parameters)) {
            arrayList.add(this.parameters);
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (this.name == null) {
            return false;
        }
        if (object instanceof ToolDefinition) {
            ToolDefinition toolDefinition = (ToolDefinition)object;
            return this.name.equals(toolDefinition.getName());
        }
        if (object instanceof String) {
            return this.name.equals((String)object);
        }
        return false;
    }

    public int hashCode() {
        int n = 7;
        n = 43 * n + (this.name != null ? this.name.hashCode() : 0);
        return n;
    }
}

