/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.db.exporter.InfinityLiterals;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class WbDateFormatter {
    private String pattern;
    private String patternWithoutTZ;
    private DateTimeFormatter formatter;
    private DateTimeFormatter formatterWithoutTimeZone;
    public static final long DATE_POSITIVE_INFINITY = 9223372036825200000L;
    public static final long DATE_NEGATIVE_INFINITY = -9223372036832400000L;
    private InfinityLiterals infinityLiterals = InfinityLiterals.PG_LITERALS;
    private boolean illegalDateAsNull;
    private boolean containsTimeFields;
    private final String timeFields = "ahKkHmsSAnNVzOXxZ";
    private Locale localeToUse;
    private Pattern timezonePatterns = Pattern.compile("( ){0,1}[zV]+");
    private Pattern offsetPatterns = Pattern.compile("( ){0,1}[XxZO]+");
    private boolean containsTZOffset;
    private boolean containsTimeZone;

    public WbDateFormatter(String string) {
        this.applyPattern(string, false);
    }

    public WbDateFormatter(String string, Locale locale) {
        this.localeToUse = locale;
        this.applyPattern(string, false);
    }

    public WbDateFormatter(String string, boolean bl) {
        this.applyPattern(string, bl);
    }

    public WbDateFormatter() {
        this.applyPattern("yyyy-MM-dd");
    }

    public void setLocale(Locale locale) {
        this.localeToUse = locale;
    }

    public void setIllegalDateIsNull(boolean bl) {
        this.illegalDateAsNull = bl;
        this.formatter = this.illegalDateAsNull ? this.formatter.withResolverStyle(ResolverStyle.STRICT) : this.formatter.withResolverStyle(ResolverStyle.SMART);
    }

    public void applyPattern(String string) {
        this.applyPattern(string, false);
    }

    public boolean patternContainesTimeZoneInformation() {
        return this.containsTimeZone || this.containsTZOffset;
    }

    public void applyPattern(String string, boolean bl) {
        this.formatter = this.createFormatter(string, bl);
        this.pattern = string;
        this.patternWithoutTZ = null;
        this.containsTimeFields = this.checkForTimeFields();
        this.formatterWithoutTimeZone = null;
        this.containsTimeZone = this.containsTimezonePattern(string);
        this.containsTZOffset = this.containsOffsetPattern(string);
        if (this.patternContainesTimeZoneInformation()) {
            Matcher matcher = this.timezonePatterns.matcher(string);
            string = matcher.replaceAll("");
            matcher = this.offsetPatterns.matcher(string);
            this.patternWithoutTZ = string = matcher.replaceAll("");
            this.formatterWithoutTimeZone = this.createFormatter(string, bl);
        }
    }

    public DateTimeFormatter createFormatter(String string, boolean bl) {
        Object object;
        Object object2;
        DateTimeFormatterBuilder dateTimeFormatterBuilder = null;
        if (bl && ((Matcher)(object2 = ((Pattern)(object = Pattern.compile("\\.S{1,6}"))).matcher(string))).find()) {
            int n = ((Matcher)object2).start();
            int n2 = ((Matcher)object2).end();
            String string2 = string.substring(0, n);
            String string3 = string.substring(n2);
            dateTimeFormatterBuilder = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern(string2);
            int n3 = n2 - n;
            dateTimeFormatterBuilder.appendFraction(ChronoField.MICRO_OF_SECOND, 0, n3 - 1, true);
            if (string3 != null) {
                dateTimeFormatterBuilder.appendPattern(string3);
            }
        }
        if (dateTimeFormatterBuilder == null) {
            dateTimeFormatterBuilder = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern(string);
        }
        object = null;
        object = this.localeToUse != null ? dateTimeFormatterBuilder.toFormatter(this.localeToUse) : dateTimeFormatterBuilder.toFormatter();
        object2 = ((DateTimeFormatter)object).withResolverStyle(ResolverStyle.SMART);
        return object2;
    }

    private boolean containsTimezonePattern(String string) {
        return this.timezonePatterns.matcher(string).find();
    }

    private boolean containsOffsetPattern(String string) {
        return this.offsetPatterns.matcher(string).find();
    }

    private boolean checkForTimeFields() {
        for (int i = 0; i < "ahKkHmsSAnNVzOXxZ".length(); ++i) {
            if (this.pattern.indexOf("ahKkHmsSAnNVzOXxZ".charAt(i)) <= -1) continue;
            return true;
        }
        return false;
    }

    public void setInfinityLiterals(InfinityLiterals infinityLiterals) {
        this.infinityLiterals = infinityLiterals;
    }

    public String formatTime(LocalTime localTime) {
        if (localTime == null) {
            return "";
        }
        return this.formatter.format(localTime);
    }

    public String formatTime(Time time) {
        if (time == null) {
            return "";
        }
        return this.formatter.format(time.toLocalTime());
    }

    public String formatUtilDate(java.util.Date date) {
        if (date == null) {
            return "";
        }
        if (date instanceof Date) {
            return this.formatDate((Date)date);
        }
        String string = this.getInfinityValue(date.getTime());
        if (string != null) {
            return string;
        }
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        return this.formatter.format(localDateTime);
    }

    public String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        String string = this.getInfinityValue(date.getTime());
        if (string != null) {
            return string;
        }
        if (this.containsTimeFields) {
            java.util.Date date2 = new java.util.Date(date.getTime());
            LocalDateTime localDateTime = LocalDateTime.ofInstant(date2.toInstant(), ZoneId.systemDefault());
            return this.formatter.format(localDateTime);
        }
        return this.formatter.format(date.toLocalDate());
    }

    private String getInfinityValue(long l) {
        if (this.infinityLiterals != null) {
            if (l == 9223372036825200000L) {
                return this.infinityLiterals.getPositiveInfinity();
            }
            if (l == -9223372036832400000L) {
                return this.infinityLiterals.getNegativeInfinity();
            }
        }
        return null;
    }

    private String getInfinityFromYear(int n) {
        if (this.infinityLiterals != null) {
            if (n == LocalDate.MAX.getYear()) {
                return this.infinityLiterals.getPositiveInfinity();
            }
            if (n == LocalDate.MIN.getYear()) {
                return this.infinityLiterals.getNegativeInfinity();
            }
        }
        return null;
    }

    public String formatDate(LocalDate localDate) {
        if (localDate == null) {
            return "";
        }
        String string = this.getInfinityFromYear(localDate.getYear());
        if (string != null) {
            return string;
        }
        if (this.formatterWithoutTimeZone != null) {
            return this.formatterWithoutTimeZone.format(localDate);
        }
        return this.formatter.format(localDate);
    }

    public String formatTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            return "";
        }
        String string = this.getInfinityValue(timestamp.getTime());
        if (string != null) {
            return string;
        }
        LocalDateTime localDateTime = timestamp.toLocalDateTime();
        if (this.formatterWithoutTimeZone != null) {
            return this.formatterWithoutTimeZone.format(localDateTime);
        }
        return this.formatter.format(localDateTime);
    }

    public String formatTimestamp(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return "";
        }
        String string = this.getInfinityFromYear(localDateTime.getYear());
        if (string != null) {
            return string;
        }
        if (this.formatterWithoutTimeZone != null) {
            return this.formatterWithoutTimeZone.format(localDateTime);
        }
        return this.formatter.format(localDateTime);
    }

    public String formatTimestamp(ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            return "";
        }
        String string = this.getInfinityFromYear(zonedDateTime.getYear());
        if (string != null) {
            return string;
        }
        return this.formatter.format(zonedDateTime);
    }

    public String formatTimestamp(OffsetDateTime offsetDateTime) {
        if (offsetDateTime == null) {
            return "";
        }
        if (this.infinityLiterals != null) {
            if (offsetDateTime.equals(OffsetDateTime.MAX)) {
                return this.infinityLiterals.getPositiveInfinity();
            }
            if (offsetDateTime.equals(OffsetDateTime.MIN)) {
                return this.infinityLiterals.getNegativeInfinity();
            }
        }
        return this.formatter.format(offsetDateTime);
    }

    public static boolean isTimestampValue(Object object) {
        return object instanceof Timestamp || object instanceof LocalDateTime || object instanceof OffsetDateTime || object instanceof ZonedDateTime;
    }

    public static boolean isDateValue(Object object) {
        return object instanceof Date || object instanceof LocalDate || object instanceof java.util.Date;
    }

    public static boolean isTimeValue(Object object) {
        return object instanceof Time || object instanceof LocalTime;
    }

    public static boolean isDateTimeValue(Object object) {
        return WbDateFormatter.isTimestampValue(object) || WbDateFormatter.isDateValue(object) || WbDateFormatter.isTimeValue(object);
    }

    public String formatDateTimeValue(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Timestamp) {
            return this.formatTimestamp((Timestamp)object);
        }
        if (object instanceof LocalDateTime) {
            return this.formatTimestamp((LocalDateTime)object);
        }
        if (object instanceof OffsetDateTime) {
            return this.formatTimestamp((OffsetDateTime)object);
        }
        if (object instanceof ZonedDateTime) {
            return this.formatTimestamp((ZonedDateTime)object);
        }
        if (object instanceof LocalTime) {
            return this.formatTime((LocalTime)object);
        }
        if (object instanceof LocalDate) {
            return this.formatDate((LocalDate)object);
        }
        if (object instanceof Time) {
            return this.formatTime((Time)object);
        }
        if (object instanceof Date) {
            return this.formatDate((Date)object);
        }
        if (object instanceof java.util.Date) {
            return this.formatUtilDate((java.util.Date)object);
        }
        LogMgr.logError(new CallerInfo(){}, "formatDateTimeValue() called with an instance that is not a date/time value", new Exception("Backtrace"));
        return object.toString();
    }

    public Time parseTimeQuitely(String string) {
        try {
            return this.parseTime(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Time parseTime(String string) throws ParseException {
        LocalTime localTime = LocalTime.parse(string, this.formatter);
        return Time.valueOf(localTime);
    }

    public Date parseDateQuietely(String string) {
        if ((string = StringUtil.trimToNull(string)) == null) {
            return null;
        }
        try {
            return this.parseDate(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            return null;
        }
    }

    public Date parseDate(String string) throws DateTimeParseException {
        if ((string = StringUtil.trimToNull(string)) == null) {
            return null;
        }
        if (this.infinityLiterals != null) {
            if (string.equalsIgnoreCase(this.infinityLiterals.getPositiveInfinity())) {
                return new Date(9223372036825200000L);
            }
            if (string.equalsIgnoreCase(this.infinityLiterals.getNegativeInfinity())) {
                return new Date(-9223372036832400000L);
            }
        }
        try {
            LocalDate localDate = LocalDate.parse(string, this.formatter);
            return Date.valueOf(localDate);
        }
        catch (DateTimeParseException dateTimeParseException) {
            if (this.illegalDateAsNull) {
                return null;
            }
            throw dateTimeParseException;
        }
    }

    public Timestamp parseTimestampQuietly(String string) {
        try {
            return this.parseTimestamp(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            return null;
        }
    }

    public Temporal parseTimestampTZ(String string) throws DateTimeParseException {
        if (string == null) {
            return null;
        }
        if (!this.containsTimeFields) {
            LocalDate localDate = LocalDate.parse(string, this.formatter);
            return ZonedDateTime.of(localDate, LocalTime.MIDNIGHT, ZoneId.systemDefault());
        }
        if (this.infinityLiterals != null) {
            if (string.trim().equalsIgnoreCase(this.infinityLiterals.getPositiveInfinity())) {
                return ZonedDateTime.of(LocalDateTime.MAX, ZoneId.ofOffset("", ZoneOffset.UTC));
            }
            if (string.trim().equalsIgnoreCase(this.infinityLiterals.getNegativeInfinity())) {
                return ZonedDateTime.of(LocalDateTime.MIN, ZoneId.ofOffset("", ZoneOffset.UTC));
            }
        }
        try {
            TemporalAccessor temporalAccessor = this.formatter.parse(string);
            ZoneId zoneId = TemporalQueries.zoneId().queryFrom(temporalAccessor);
            ZoneOffset zoneOffset = TemporalQueries.offset().queryFrom(temporalAccessor);
            LocalDate localDate = TemporalQueries.localDate().queryFrom(temporalAccessor);
            LocalTime localTime = TemporalQueries.localTime().queryFrom(temporalAccessor);
            if (zoneId != null) {
                return ZonedDateTime.of(localDate, localTime, zoneId);
            }
            if (zoneOffset != null) {
                return OffsetDateTime.of(localDate, localTime, zoneOffset);
            }
            return LocalDateTime.of(localDate, localTime);
        }
        catch (DateTimeParseException dateTimeParseException) {
            if (this.illegalDateAsNull) {
                return null;
            }
            throw dateTimeParseException;
        }
    }

    public Timestamp parseTimestamp(String string) throws DateTimeParseException {
        if (string == null) {
            return null;
        }
        if (!this.containsTimeFields) {
            Date date = this.parseDate(string);
            return new Timestamp(date.getTime());
        }
        if (this.infinityLiterals != null) {
            if (string.trim().equalsIgnoreCase(this.infinityLiterals.getPositiveInfinity())) {
                return new Timestamp(9223372036825200000L);
            }
            if (string.trim().equalsIgnoreCase(this.infinityLiterals.getNegativeInfinity())) {
                return new Timestamp(-9223372036832400000L);
            }
        }
        try {
            LocalDateTime localDateTime = LocalDateTime.parse(string, this.formatter);
            return Timestamp.valueOf(localDateTime);
        }
        catch (DateTimeParseException dateTimeParseException) {
            if (this.illegalDateAsNull) {
                return null;
            }
            throw dateTimeParseException;
        }
    }

    public String getPatternWithoutTimeZone() {
        if (this.patternWithoutTZ != null) {
            return this.patternWithoutTZ;
        }
        return this.toPattern();
    }

    public String toPattern() {
        return this.pattern;
    }

    public static String getDisplayValue(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Date) {
            String string = Settings.getInstance().getDefaultDateFormat();
            WbDateFormatter wbDateFormatter = new WbDateFormatter(string);
            return wbDateFormatter.formatDate((Date)object);
        }
        if (object instanceof Timestamp) {
            String string = Settings.getInstance().getDefaultTimestampFormat();
            WbDateFormatter wbDateFormatter = new WbDateFormatter(string);
            return wbDateFormatter.formatTimestamp((Timestamp)object);
        }
        if (object instanceof ZonedDateTime) {
            String string = Settings.getInstance().getDefaultTimestampFormat();
            WbDateFormatter wbDateFormatter = new WbDateFormatter(string);
            return wbDateFormatter.formatTimestamp((ZonedDateTime)object);
        }
        if (object instanceof OffsetDateTime) {
            String string = Settings.getInstance().getDefaultTimestampFormat();
            WbDateFormatter wbDateFormatter = new WbDateFormatter(string);
            return wbDateFormatter.formatTimestamp((OffsetDateTime)object);
        }
        if (object instanceof LocalDate) {
            String string = Settings.getInstance().getDefaultDateFormat();
            WbDateFormatter wbDateFormatter = new WbDateFormatter(string);
            return wbDateFormatter.formatDate((LocalDate)object);
        }
        if (object instanceof LocalDateTime) {
            String string = Settings.getInstance().getDefaultTimestampFormat();
            WbDateFormatter wbDateFormatter = new WbDateFormatter(string);
            return wbDateFormatter.formatTimestamp((LocalDateTime)object);
        }
        if (object instanceof java.util.Date) {
            long l = ((java.util.Date)object).getTime();
            if (l == 9223372036825200000L) {
                return "infinity";
            }
            if (l == -9223372036832400000L) {
                return "-infinity";
            }
        }
        return object.toString();
    }

    public static ZoneOffset getSystemDefaultOffset() {
        Instant instant = Instant.now();
        ZoneId zoneId = ZoneId.systemDefault();
        return zoneId.getRules().getOffset(instant);
    }
}

