/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.FileUtil;
import workbench.util.StringUtil;

public class WbFile
extends File {
    public WbFile(String string, String string2) {
        super(StringUtil.replaceProperties(string), StringUtil.replaceProperties(string2));
    }

    public WbFile(File file, String string) {
        super(file, StringUtil.replaceProperties(string));
    }

    public WbFile(File file) {
        super(file.getAbsolutePath());
    }

    public WbFile(String string) {
        super(StringUtil.replaceProperties(string));
    }

    public WbFile makeBackup() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
        String string = this.getName() + "." + simpleDateFormat.format(new Date());
        WbFile wbFile = new WbFile(this.getParent(), string);
        try {
            FileUtil.copy(this, wbFile);
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not copy " + this.getFullPath() + " to " + wbFile.getFullPath());
            return null;
        }
        return wbFile;
    }

    public String getFileName() {
        String string = this.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public String getExtension() {
        String string = this.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1);
    }

    public boolean isWriteable() {
        if (this.exists()) {
            return this.canWrite();
        }
        return this.canCreate();
    }

    public boolean canCreate() {
        try {
            this.tryCreate();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void tryCreate() throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this);
        }
        catch (Throwable throwable) {
            FileUtil.closeQuietely(fileOutputStream);
            this.delete();
            throw throwable;
        }
        FileUtil.closeQuietely(fileOutputStream);
        this.delete();
    }

    public String getFullPath() {
        try {
            return this.getCanonicalPath();
        }
        catch (Throwable throwable) {
            return this.getAbsolutePath();
        }
    }

    @Override
    public String toString() {
        return this.getFullPath();
    }
}

