/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.beans.BeanInfo;
import java.beans.ExceptionListener;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.FileUtil;

public class WbPersistence
implements ExceptionListener {
    private String filename;

    public WbPersistence() {
    }

    public WbPersistence(String string) {
        this.filename = string;
    }

    public static void makeTransient(Class clazz, String string) {
        try {
            PropertyDescriptor[] propertyDescriptorArray;
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = beanInfo.getPropertyDescriptors()) {
                if (!propertyDescriptor.getName().equals(string)) continue;
                propertyDescriptor.setValue("transient", Boolean.TRUE);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    public Object readObject() throws Exception {
        if (this.filename == null) {
            throw new IllegalArgumentException("No filename specified!");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.filename));
        return this.readObject(bufferedInputStream);
    }

    /*
     * Loose catch block
     */
    public Object readObject(InputStream inputStream) throws Exception {
        try {
            try (XMLDecoder xMLDecoder = new XMLDecoder(inputStream, null, this);){
                Object object;
                Object object2 = object = xMLDecoder.readObject();
                return object2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            FileUtil.closeQuietely(inputStream);
        }
    }

    public void writeObject(Object object) throws IOException {
        if (object == null) {
            return;
        }
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.filename), 32768);
             XMLEncoder xMLEncoder = new XMLEncoder(bufferedOutputStream);){
            xMLEncoder.writeObject(object);
        }
    }

    @Override
    public void exceptionThrown(Exception exception) {
        LogMgr.logError(new CallerInfo(){}, "Error reading file " + this.filename, exception);
    }
}

