/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class XsltTransformer
implements URIResolver {
    private Exception nestedError;
    private File xsltBasedir;
    private String sysOut;
    private String sysErr;
    private boolean saveSystemOut;
    private File xsltUsed;
    private List<String> ignoredMessages = new ArrayList<String>();
    private File sourceDir;

    public XsltTransformer() {
        this.ignoredMessages.add("'https://javax.xml.XMLConstants/property/accessExternalDTD'");
        this.ignoredMessages.add("'https://javax.xml.XMLConstants/feature/secure-processing'");
        this.ignoredMessages.add("'https://www.oracle.com/xml/jaxp/properties/entityExpansionLimit'");
    }

    public void setXsltBaseDir(File file) {
        this.xsltBasedir = file;
    }

    public void setSaveSystemOutMessages(boolean bl) {
        this.saveSystemOut = bl;
    }

    public void transform(String string, String string2, String string3) throws IOException, TransformerException {
        this.transform(string, string2, string3, null);
    }

    public File getXsltUsed() {
        return this.xsltUsed;
    }

    public void transform(String string, String string2, String string3, Map<String, String> map) throws IOException, TransformerException {
        File file = new File(string);
        File file2 = new File(string2);
        File file3 = this.findStylesheet(string3);
        this.transform(file, file2, file3, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(File file, File file2, File file3, Map<String, String> map) throws IOException, TransformerException {
        if (!file3.exists()) {
            throw new FileNotFoundException("File " + file3.getAbsolutePath() + " doesn't exist");
        }
        this.xsltUsed = file3;
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        FileInputStream fileInputStream = null;
        Transformer transformer = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream2 = null;
        PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        try {
            Object object;
            fileInputStream = new FileInputStream(file3);
            this.sourceDir = file3.getAbsoluteFile().getParentFile();
            if (this.saveSystemOut) {
                byteArrayOutputStream = new ByteArrayOutputStream();
                System.setOut(new PrintStream(byteArrayOutputStream));
                byteArrayOutputStream2 = new ByteArrayOutputStream();
                System.setErr(new PrintStream(byteArrayOutputStream2){

                    @Override
                    public void println(String string) {
                        if (!XsltTransformer.this.ignoreXsltMessage(string)) {
                            super.println(string);
                        }
                    }
                });
            }
            StreamSource streamSource = new StreamSource(fileInputStream);
            streamSource.setSystemId(file3.getName());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setURIResolver(this);
            transformer = transformerFactory.newTransformer(streamSource);
            transformer.setURIResolver(this);
            if (map != null) {
                for (Map.Entry object22 : map.entrySet()) {
                    object = StringUtil.decodeUnicode((String)object22.getValue());
                    transformer.setParameter((String)object22.getKey(), object);
                }
            }
            File file4 = file2.getAbsoluteFile().getParentFile();
            transformer.setParameter("wb-basedir", file4.getAbsolutePath());
            File file5 = file.getAbsoluteFile().getParentFile();
            transformer.setParameter("wb-scriptdir", file5.getAbsolutePath());
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 32768);
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2), 32768);
            object = new StreamSource(bufferedInputStream);
            StreamResult streamResult = new StreamResult(bufferedOutputStream);
            transformer.transform((Source)object, streamResult);
        }
        catch (Throwable throwable) {
            FileUtil.closeQuietely(fileInputStream);
            FileUtil.closeQuietely(bufferedInputStream);
            FileUtil.closeQuietely(bufferedOutputStream);
            if (this.saveSystemOut) {
                System.setOut(printStream);
                System.setErr(printStream2);
                this.sysOut = byteArrayOutputStream != null ? byteArrayOutputStream.toString() : null;
                this.sysErr = byteArrayOutputStream2 != null ? byteArrayOutputStream2.toString() : null;
            }
            throw throwable;
        }
        FileUtil.closeQuietely(fileInputStream);
        FileUtil.closeQuietely(bufferedInputStream);
        FileUtil.closeQuietely(bufferedOutputStream);
        if (this.saveSystemOut) {
            System.setOut(printStream);
            System.setErr(printStream2);
            this.sysOut = byteArrayOutputStream != null ? byteArrayOutputStream.toString() : null;
            this.sysErr = byteArrayOutputStream2 != null ? byteArrayOutputStream2.toString() : null;
        }
    }

    private boolean ignoreXsltMessage(String string) {
        for (String string2 : this.ignoredMessages) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    public Exception getNestedError() {
        return this.nestedError;
    }

    public String getAllOutputs() {
        return this.getAllOutputs(null);
    }

    private String getSystemErr() {
        if (StringUtil.isBlank(this.sysErr)) {
            return "";
        }
        return this.sysErr.replace("Compiler warnings:", "").trim();
    }

    public String getAllOutputs(Exception exception) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getSystemErr());
        if (StringUtil.isNonBlank(this.sysOut)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(this.sysOut.trim());
        }
        if (this.nestedError != null) {
            stringBuilder.append('\n');
            if (exception != null) {
                stringBuilder.append(exception.getMessage());
                stringBuilder.append(": ");
            }
            stringBuilder.append(ExceptionUtil.getDisplay(this.nestedError));
        }
        if (stringBuilder.length() == 0 && exception != null) {
            stringBuilder.append(ResourceMgr.getFormattedString("ErrXsltProcessing", this.xsltUsed.getAbsolutePath(), ExceptionUtil.getDisplay(exception)));
        }
        return stringBuilder.toString();
    }

    @Override
    public Source resolve(String string, String string2) throws TransformerException {
        File file = new File(string2);
        try {
            if (file.exists()) {
                return new StreamSource(new FileInputStream(file));
            }
            File file2 = new File(this.sourceDir, string);
            if (file2.exists()) {
                return new StreamSource(new FileInputStream(file2));
            }
            file2 = this.findStylesheet(string);
            return new StreamSource(new FileInputStream(file2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.nestedError = fileNotFoundException;
            throw new TransformerException(fileNotFoundException);
        }
    }

    public File findStylesheet(String string) {
        File file;
        File file2;
        WbFile wbFile = new WbFile(string);
        if (StringUtil.isEmptyString(wbFile.getExtension())) {
            string = string + ".xslt";
            wbFile = new WbFile(string);
        }
        if (wbFile.exists()) {
            return wbFile;
        }
        if (wbFile.getParentFile() == null) {
            if (this.xsltUsed != null && this.xsltUsed.getParentFile() != null && this.xsltUsed.exists() && (file2 = new File(file = this.xsltUsed.getParentFile(), string)).exists()) {
                return file2;
            }
            file = Settings.getInstance().getDefaultXsltDirectory();
            file2 = new File(file, string);
            if (file2.exists()) {
                return file2;
            }
        }
        if (this.xsltBasedir != null && (file = new File(this.xsltBasedir, string)).exists()) {
            return file;
        }
        file = Settings.getInstance().getConfigDir();
        file2 = new File(file, string);
        if (file2.exists()) {
            return file2;
        }
        return new File(string);
    }
}

