/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import workbench.util.EncodingUtil;
import workbench.util.OutputFactory;
import workbench.util.ZipEntryOutputStream;

public class ZipOutputFactory
implements OutputFactory {
    protected File archive;
    protected OutputStream baseOut;
    protected ZipOutputStream zout;

    public ZipOutputFactory(File file) {
        this.archive = file;
    }

    private void initArchive() throws IOException {
        this.baseOut = new FileOutputStream(this.archive);
        this.zout = new ZipOutputStream(this.baseOut);
        this.zout.setLevel(9);
    }

    @Override
    public boolean isArchive() {
        return true;
    }

    @Override
    public OutputStream createOutputStream(File file) throws IOException {
        String string = file.getName();
        return this.createOutputStream(string);
    }

    public OutputStream createOutputStream(String string) throws IOException {
        if (this.zout == null) {
            this.initArchive();
        }
        ZipEntry zipEntry = new ZipEntry(string);
        this.zout.putNextEntry(zipEntry);
        return new ZipEntryOutputStream(this.zout);
    }

    @Override
    public void writeUncompressedString(String string, String string2) throws IOException {
        if (this.zout == null) {
            this.initArchive();
        }
        try {
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setMethod(0);
            byte[] byArray = string2.getBytes("UTF-8");
            zipEntry.setSize(byArray.length);
            zipEntry.setCompressedSize(byArray.length);
            CRC32 cRC32 = new CRC32();
            cRC32.update(byArray);
            zipEntry.setCrc(cRC32.getValue());
            this.zout.putNextEntry(zipEntry);
            this.zout.write(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    public Writer createWriter(String string, String string2) throws IOException {
        OutputStream outputStream = this.createOutputStream(string);
        return EncodingUtil.createWriter(outputStream, string2);
    }

    @Override
    public Writer createWriter(File file, String string) throws IOException {
        OutputStream outputStream = this.createOutputStream(file);
        return EncodingUtil.createWriter(outputStream, string);
    }

    @Override
    public void done() throws IOException {
        if (this.zout != null) {
            this.zout.close();
        }
        if (this.baseOut != null) {
            this.baseOut.close();
        }
    }
}

