/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.stretch.operation;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.vectorediting.lib.prov.stretch.operation.StretchOperation;
import org.gvsig.vectorediting.lib.prov.stretch.operation.StretchOperationUtils;

public class CurveStretchOperation
implements StretchOperation {
    @Override
    public Geometry transform(AffineTransform at, Primitive geom, Geometry roi) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        Line line = geometryManager.createLine(geom.getGeometryType().getSubType());
        line.setGeneralPath((GeneralPathX)geom.getGeneralPath().clone());
        for (int j = 0; j < line.getNumVertices(); ++j) {
            Point point = line.getVertex(j);
            if (!roi.intersects((Geometry)point) && !roi.contains((Geometry)point)) continue;
            point.transform(at);
            StretchOperationUtils.setVertex((OrientablePrimitive)line, j, point);
        }
        return line;
    }

    @Override
    public List<Point> getSelectedVertex(Primitive geom, Geometry roi) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        ArrayList<Point> vertexList = new ArrayList<Point>();
        Line line = geometryManager.createLine(geom.getGeometryType().getSubType());
        line.setGeneralPath(geom.getGeneralPath());
        for (int j = 0; j < line.getNumVertices(); ++j) {
            Point point = line.getVertex(j);
            if (!roi.intersects((Geometry)point) && !roi.contains((Geometry)point)) continue;
            vertexList.add(point);
        }
        return vertexList;
    }
}

