/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.spi;

import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureProviderIterator;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureStoreProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureSetProvider;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.SpatialIndex;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFeatureSetProvider
extends AbstractDisposable
implements FeatureSetProvider {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractFeatureSetProvider.class);
    private final AbstractFeatureStoreProvider store;
    private final FeatureQuery query;
    private final FeatureType providerFeatureType;
    private final FeatureType storeFeatureType;

    public AbstractFeatureSetProvider(AbstractFeatureStoreProvider store, FeatureQuery query, FeatureType providerFeatureType, FeatureType storeFeatureType) {
        this.store = store;
        this.query = query;
        this.providerFeatureType = providerFeatureType;
        this.storeFeatureType = storeFeatureType;
    }

    public AbstractFeatureSetProvider(AbstractFeatureStoreProvider store, FeatureQuery query, FeatureType providerFeatureType) {
        this(store, query, providerFeatureType, null);
    }

    protected AbstractFeatureStoreProvider getStore() {
        return this.store;
    }

    protected FeatureQuery getQuery() {
        return this.query;
    }

    protected FeatureType getProviderFeatureType() {
        return this.providerFeatureType;
    }

    protected FeatureType getStoreFeatureType() {
        return this.storeFeatureType;
    }

    protected FeatureType getFeatureType() {
        return this.providerFeatureType;
    }

    @Override
    public final DisposableIterator fastIterator() throws DataException {
        return this.fastIterator(0L);
    }

    public final DisposableIterator fastIterator(long index) throws DataException {
        return this.createFastIterator(index);
    }

    @Override
    public final DisposableIterator fastIterator(long index, long elements) throws DataException {
        return this.createFastIterator(index, elements);
    }

    @Override
    public final DisposableIterator iterator() throws DataException {
        return this.iterator(0L);
    }

    public final DisposableIterator iterator(long index) throws DataException {
        return this.createIterator(index);
    }

    @Override
    public final DisposableIterator iterator(long index, long elements) throws DataException {
        return this.createIterator(index, elements);
    }

    protected abstract AbstractFeatureProviderIterator createIterator(long var1) throws DataException;

    protected AbstractFeatureProviderIterator createIterator(long index, long elements) throws DataException {
        return this.createIterator(index);
    }

    protected abstract AbstractFeatureProviderIterator createFastIterator(long var1) throws DataException;

    protected AbstractFeatureProviderIterator createFastIterator(long index, long elements) throws DataException {
        return this.createFastIterator(index);
    }

    public String toString() {
        try {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            builder.append("store", (Object)this.store, true);
            builder.append("query", (Object)this.query, true);
            return builder.toString();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    protected SpatialIndex getSpatialIndex(String name) {
        return null;
    }

    protected Iterator createSpatialIterator(FeatureType featureType, FeatureQuery query) {
        if (featureType == null || query == null || query.getFilter() == null) {
            return null;
        }
        ExpressionEvaluatorManager expmanager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
        Code filterCode = null;
        try {
            SymbolTable filterSymbolTable = null;
            Expression filterExp = query.getExpressionFilter();
            if (filterExp == null) {
                String sql = query.getFilter().getSQL();
                if (sql == null) {
                    return null;
                }
                filterCode = expmanager.compile(sql);
            } else {
                filterCode = filterExp.getCode();
                filterSymbolTable = filterExp.getSymbolTable();
            }
            final MutableObject spatialQuery = new MutableObject();
            final MutableObject spatialIndex = new MutableObject();
            try {
                filterCode.accept(new Visitor(){

                    public void visit(Object obj) throws VisitCanceledException, BaseException {
                        SpatialIndex spaIndex = null;
                        if (Code.isFunction((Code)((Code)obj), (String)"NOT") && spatialIndex.getValue() == null) {
                            Code isCode = (Code)((Code.Callable)obj).parameters().get(0);
                            if (Code.isFunction((Code)isCode, (String)"IS")) {
                                Code p1 = (Code)((Code.Callable)isCode).parameters().get(0);
                                Code p2 = (Code)((Code.Callable)isCode).parameters().get(1);
                                if (p1.code() == 1 && p2.code() == 0 && ((Code.Constant)p2).value() == null && (spaIndex = AbstractFeatureSetProvider.this.getSpatialIndex(((Code.Identifier)p1).name())) != null) {
                                    spatialIndex.setValue((Object)spaIndex);
                                }
                            }
                        } else if (Code.isFunction((Code)((Code)obj), (String)"ST_INTERSECTS") || Code.isFunction((Code)((Code)obj), (String)"ST_CONTAINS") || Code.isFunction((Code)((Code)obj), (String)"&&")) {
                            Code.Callable intersects = (Code.Callable)obj;
                            Code p1 = (Code)intersects.parameters().get(0);
                            Code p2 = (Code)intersects.parameters().get(1);
                            Code sq = null;
                            if (p1.code() == 1) {
                                spaIndex = AbstractFeatureSetProvider.this.getSpatialIndex(((Code.Identifier)p1).name());
                                if (spaIndex != null) {
                                    sq = p2;
                                }
                            } else if (p2.code() == 1 && (spaIndex = AbstractFeatureSetProvider.this.getSpatialIndex(((Code.Identifier)p2).name())) != null) {
                                sq = p1;
                            }
                            if (sq != null) {
                                spatialIndex.setValue((Object)spaIndex);
                                spatialQuery.setValue((Object)sq);
                                throw new VisitCanceledException();
                            }
                        }
                    }
                });
            }
            catch (VisitCanceledException visitCanceledException) {
                // empty catch block
            }
            if (spatialIndex.getValue() != null && spatialQuery.getValue() != null) {
                Interpreter interpreter = expmanager.createInterpreter();
                if (filterSymbolTable instanceof MutableSymbolTable) {
                    interpreter.setSymbolTable(filterSymbolTable);
                } else {
                    MutableSymbolTable symbolTable = expmanager.createSymbolTable();
                    if (filterSymbolTable != null) {
                        symbolTable.addSymbolTable(filterSymbolTable);
                    }
                    interpreter.setSymbolTable((SymbolTable)symbolTable);
                }
                Envelope envelope = null;
                Object value = interpreter.runCode((Code)spatialQuery.getValue());
                if (value instanceof Geometry) {
                    envelope = ((Geometry)value).getEnvelope();
                } else if (value instanceof Envelope) {
                    envelope = (Envelope)value;
                }
                if (envelope != null) {
                    return ((SpatialIndex)spatialIndex.getValue()).query(envelope, Long.MAX_VALUE);
                }
            } else if (spatialIndex.getValue() != null) {
                return ((SpatialIndex)spatialIndex.getValue()).queryAll();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't use spatial index for query '" + Objects.toString(filterCode) + "'.", (Throwable)ex);
        }
        return null;
    }
}

