/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.spi;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.FeatureLocks;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.dal.feature.spi.FeatureSetProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProviderServices;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProvider_v2;
import org.gvsig.fmap.dal.resource.ResourceAction;
import org.gvsig.fmap.dal.resource.spi.ResourceManagerProviderServices;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.spi.AbstractDataStoreProvider;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.timesupport.Interval;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObject_v2;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.util.UnmodifiableBasicMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFeatureStoreProvider
extends AbstractDataStoreProvider
implements FeatureStoreProvider_v2 {
    protected FeatureStoreProviderServices store;
    private DelegatedDynObject metadata;
    private DataStoreParameters parameters;
    private static final Logger logger = LoggerFactory.getLogger(AbstractFeatureStoreProvider.class);

    protected AbstractFeatureStoreProvider(DataStoreParameters params, DataStoreProviderServices storeServices, DynObject metadata) {
        this.store = (FeatureStoreProviderServices)storeServices;
        this.metadata = (DelegatedDynObject)metadata;
        this.parameters = params;
    }

    protected AbstractFeatureStoreProvider(DataStoreParameters params, DataStoreProviderServices storeServices) {
        this.store = (FeatureStoreProviderServices)storeServices;
        this.metadata = null;
        this.parameters = params;
    }

    @Override
    public final FeatureProvider getFeatureProviderByReference(final FeatureReferenceProviderServices reference) throws DataException {
        this.open();
        FeatureProvider featureProvider = (FeatureProvider)this.getResource().execute(new ResourceAction(){

            public Object run() throws Exception {
                return AbstractFeatureStoreProvider.this.internalGetFeatureProviderByReference(reference);
            }

            public String toString() {
                return "getFeatureByReference";
            }
        });
        if (featureProvider == null) {
            throw new FeatureProviderNotFoundException(reference);
        }
        return featureProvider;
    }

    @Override
    public final FeatureProvider getFeatureProviderByReference(final FeatureReferenceProviderServices reference, final FeatureType featureType) throws DataException {
        this.open();
        FeatureProvider featureProvider = (FeatureProvider)this.getResource().execute(new ResourceAction(){

            public Object run() throws Exception {
                return AbstractFeatureStoreProvider.this.internalGetFeatureProviderByReference(reference, featureType);
            }
        });
        if (featureProvider == null) {
            throw new FeatureProviderNotFoundException(reference);
        }
        return featureProvider;
    }

    protected FeatureProvider internalGetFeatureProviderByReference(FeatureReferenceProviderServices reference) throws DataException {
        return this.internalGetFeatureProviderByReference(reference, this.getStoreServices().getDefaultFeatureType());
    }

    protected void setMetadata(DynObject metadata) {
        if (this.metadata != null) {
            throw new IllegalStateException();
        }
        this.metadata = (DelegatedDynObject)metadata;
    }

    @Override
    public DataStoreParameters getParameters() {
        return this.parameters;
    }

    protected ResourceProvider createResource(String type, Object[] params) throws InitializeException {
        ResourceManagerProviderServices manager = (ResourceManagerProviderServices)DALLocator.getResourceManager();
        ResourceProvider resource = manager.createAddResource(type, params);
        return resource;
    }

    @Override
    public FeatureStoreProviderServices getStoreServices() {
        return this.store;
    }

    protected void setStoreServices(FeatureStoreProviderServices store) {
        this.store = store;
    }

    @Override
    public FeatureStore getFeatureStore() {
        FeatureStoreProviderServices services = this.getStoreServices();
        if (services == null) {
            return null;
        }
        return services.getFeatureStore();
    }

    @Override
    public boolean allowWrite() {
        return false;
    }

    @Override
    public void performChanges(Iterator deleteds, Iterator inserteds, Iterator updateds, Iterator featureTypesChanged) throws DataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLocksSupported() {
        return false;
    }

    @Override
    public FeatureProvider createFeatureProvider(FeatureType type) throws DataException {
        FeatureStoreProviderServices services = this.getStoreServices();
        return services.createDefaultFeatureProvider(type);
    }

    @Override
    public FeatureLocks createFeatureLocks() throws DataException {
        return null;
    }

    @Override
    public FeatureSelection createFeatureSelection() throws DataException {
        FeatureStoreProviderServices services = this.getStoreServices();
        return services.createDefaultFeatureSelection();
    }

    @Override
    public void refresh() throws OpenException {
    }

    @Override
    public void close() throws CloseException {
    }

    protected void doDispose() throws BaseException {
        this.metadata = null;
        this.store = null;
    }

    @Override
    public Envelope getEnvelope() throws DataException {
        return null;
    }

    @Override
    public Envelope getEnvelope(String geomname) throws DataException {
        return this.getEnvelope();
    }

    @Override
    public boolean canWriteGeometry(int geometryType, int geometrySubType) throws DataException {
        return false;
    }

    public void delegate(DynObject dynObject) {
        if (this.metadata == null) {
            return;
        }
        this.metadata.delegate(dynObject);
    }

    public DynClass getDynClass() {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.getDynClass();
    }

    public Object getDynValue(String name) throws DynFieldNotFoundException {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.getDynValue(name);
    }

    public boolean hasDynValue(String name) {
        if (this.metadata == null) {
            return false;
        }
        return this.metadata.hasDynValue(name);
    }

    public boolean hasDynMethod(String name) {
        if (this.metadata instanceof DynObject_v2) {
            return ((DynObject_v2)this.metadata).hasDynMethod(name);
        }
        return false;
    }

    public void implement(DynClass dynClass) {
        if (this.metadata == null) {
            return;
        }
        this.metadata.implement(dynClass);
    }

    public Object invokeDynMethod(int code, Object[] args) throws DynMethodException {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.invokeDynMethod((Object)this, code, args);
    }

    public Object invokeDynMethod(String name, Object[] args) throws DynMethodException {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.invokeDynMethod((Object)this, name, args);
    }

    public void setDynValue(String name, Object value) throws DynFieldNotFoundException {
        if (this.metadata == null) {
            return;
        }
        this.metadata.setDynValue(name, value);
    }

    @Override
    public boolean allowAutomaticValues() {
        return false;
    }

    @Override
    public void append(FeatureProvider featureProvider) throws DataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beginAppend() throws DataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beginAppend(int submode) throws DataException {
        this.beginAppend();
    }

    @Override
    public void endAppend() throws DataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void abortAppend() throws DataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsAppendMode() {
        return false;
    }

    @Override
    public UnmodifiableBasicMap<String, DataStore> getChildren() {
        return UnmodifiableBasicMap.EMPTY_UNMODIFIABLEBASICMAP;
    }

    @Override
    public StoresRepository getStoresRepository() {
        return null;
    }

    @Override
    public ResourcesStorage getResourcesStorage() {
        return null;
    }

    @Override
    public DataServerExplorer getExplorer() throws ReadException, ValidateDataParametersException {
        return null;
    }

    public void clear() {
        if (this.metadata != null) {
            this.metadata.clear();
        }
    }

    protected abstract FeatureProvider internalGetFeatureProviderByReference(FeatureReferenceProviderServices var1, FeatureType var2) throws DataException;

    @Override
    public boolean isKnownEnvelope() {
        return true;
    }

    @Override
    public boolean hasRetrievedFeaturesLimit() {
        return false;
    }

    @Override
    public int getRetrievedFeaturesLimit() {
        return -1;
    }

    @Override
    public Interval getInterval() {
        return null;
    }

    @Override
    public Collection getTimes() {
        return null;
    }

    @Override
    public Collection getTimes(Interval interval) {
        return null;
    }

    @Override
    public ExpressionBuilder createExpression() {
        ExpressionBuilder builder = ExpressionEvaluatorLocator.getManager().createExpressionBuilder();
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void savePrjFile(File dataFile, IProjection proj) {
        block4: {
            File file = new File(FilenameUtils.removeExtension((String)dataFile.getAbsolutePath()) + ".prj");
            try {
                String export = proj.export("wkt_esri");
                if (export == null) break block4;
                BufferedOutputStream os = null;
                try {
                    os = new BufferedOutputStream(FileUtils.openOutputStream((File)file));
                    IOUtils.write((String)export, (OutputStream)os, (Charset)StandardCharsets.UTF_8);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)os);
            }
            catch (Exception e) {
                logger.info("Can't write prj file '" + file.getAbsolutePath() + "'.");
            }
        }
    }

    @Override
    public boolean isTemporary() {
        return false;
    }

    @Override
    public void fixFeatureTypeFromParameters() {
    }

    @Override
    public boolean supportsPassThroughMode() {
        return false;
    }

    @Override
    public void passThroughInsert(FeatureProvider featureProvider) throws DataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void passThroughInsertOrUpdate(FeatureProvider featureProvider) throws DataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void passThroughUpdate(FeatureProvider featureProvider) throws DataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void passThroughDelete(FeatureReferenceProviderServices featureReference) throws DataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void passThroughDelete(Expression filter) throws DataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void passThroughUpdate(Object[] parameters, Expression filter) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        try {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            builder.append("parameters", (Object)this.parameters, true);
            return builder.toString();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public FeatureSetProvider createSet(FeatureQuery query, FeatureType providerFeatureType, FeatureType storeFeatureType) throws DataException {
        return this.createSet(query, storeFeatureType);
    }

    @Override
    public int allowGeometry(String name, Geometry geometry) {
        return 0;
    }

    public static class FeatureProviderNotFoundException
    extends DataException {
        private static final long serialVersionUID = 5161749797695723151L;

        public FeatureProviderNotFoundException(FeatureReference reference) {
            super("Cannot retreive FeatureProvider for reference %(reference)", "_FeatureProviderNotFoundException", 5161749797695723151L);
            this.setValue("reference", reference.toString());
        }
    }
}

