/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.spi;

import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.timesupport.Time;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.math.BigDecimalUtils;

public class DefaultFeatureProvider
implements FeatureProvider {
    protected FeatureType featureType;
    protected boolean[] nulls;
    protected Object[] values;
    protected Geometry defaultGeometry;
    protected Envelope envelope;
    private Object oid;
    private boolean isNew = false;
    private String[] extraValuesNames;
    private Object[] extraValues;
    private boolean broken;
    private int dataStatus;

    public DefaultFeatureProvider(FeatureType type) {
        this.featureType = type;
        this.values = new Object[this.featureType.size()];
        this.nulls = new boolean[this.featureType.size()];
        this.envelope = null;
        this.defaultGeometry = null;
        this.oid = null;
        this.broken = false;
    }

    public DefaultFeatureProvider(FeatureType type, Object oid) {
        this(type);
        this.oid = oid;
    }

    public DefaultFeatureProvider(FeatureType type, DefaultFeatureProvider data) {
        this(type);
        this.oid = data.oid;
        this.defaultGeometry = data.defaultGeometry;
        this.envelope = data.envelope;
        this.isNew = data.isNew;
    }

    @Override
    public boolean isReadOnly(int i) {
        FeatureAttributeDescriptor attribute = this.featureType.getAttributeDescriptor(i);
        return attribute.getEvaluator() != null;
    }

    @Override
    public void set(int i, Object value) {
        FeatureAttributeDescriptor attribute = this.featureType.getAttributeDescriptor(i);
        if (this.featureType.getDefaultGeometryAttributeIndex() == i) {
            if (value instanceof Geometry) {
                this.defaultGeometry = (Geometry)value;
            } else {
                try {
                    this.defaultGeometry = (Geometry)ToolsLocator.getDataTypesManager().coerce(66, value);
                }
                catch (CoercionException coercionException) {
                    // empty catch block
                }
            }
            this.envelope = null;
        } else if (value != null) {
            value = this.coerceToField(attribute, value);
        }
        if (value == null) {
            this.values[i] = null;
            this.nulls[i] = true;
        } else {
            this.values[i] = value;
            this.nulls[i] = false;
        }
    }

    protected Object coerceToField(FeatureAttributeDescriptor attribute, Object value) {
        Class objectClass = attribute.getObjectClass();
        if (objectClass != null) {
            if (!objectClass.isInstance(value)) {
                try {
                    Coercion coercer = attribute.getDataType().getCoercion();
                    if (attribute.getType() == 8 && value instanceof Boolean) {
                        value = coercer.coerce(value, attribute.getCoercionContext());
                        value = StringUtils.left((String)((String)value), (int)attribute.getSize());
                    }
                    value = coercer.coerce(value, attribute.getCoercionContext());
                }
                catch (CoercionException e) {
                    throw new IllegalArgumentException("Can't convert to " + attribute.getDataType().getName() + " from '" + value.getClass().getName() + "' with value '" + value.toString() + "' and context '" + attribute.getCoercionContext() + "' to assign to '" + attribute.getName() + "'.", e);
                }
            } else {
                try {
                    switch (attribute.getType()) {
                        case 19: {
                            value = BigDecimalUtils.forceScaleAndEnsurePrecision((BigDecimal)((BigDecimal)value), (int)attribute.getScale(), (int)attribute.getPrecision());
                        }
                    }
                }
                catch (Throwable th) {
                    throw new IllegalArgumentException("Can't assign " + value.toString() + " to '" + attribute.getName() + "'.", th);
                }
            }
        }
        return value;
    }

    @Override
    public void set(String name, Object value) {
        this.set(this.featureType.getIndex(name), value);
    }

    @Override
    public Object get(int i) {
        return this.values[i];
    }

    @Override
    public Object get(String name) {
        FeatureAttributeDescriptor featureAttributeDescriptor = this.featureType.getAttributeDescriptor(name);
        if (featureAttributeDescriptor == null) {
            throw new IllegalStateException("Can't get attribute '" + name + "'");
        }
        return this.values[featureAttributeDescriptor.getIndex()];
    }

    @Override
    public FeatureType getType() {
        return this.featureType;
    }

    @Override
    public FeatureProvider getCopy() {
        DefaultFeatureProvider data = new DefaultFeatureProvider(this.getType());
        return this.getCopy(data);
    }

    protected FeatureProvider getCopy(DefaultFeatureProvider data) {
        data.oid = this.oid;
        System.arraycopy(this.values, 0, data.values, 0, this.values.length);
        data.defaultGeometry = this.defaultGeometry;
        data.envelope = this.envelope;
        data.isNew = this.isNew;
        if (this.extraValues != null) {
            data.extraValues = new Object[this.extraValues.length];
            System.arraycopy(this.extraValues, 0, data.extraValues, 0, this.extraValues.length);
        } else {
            data.extraValues = null;
        }
        if (this.extraValuesNames != null) {
            data.extraValuesNames = new String[this.extraValuesNames.length];
            System.arraycopy(this.extraValuesNames, 0, data.extraValuesNames, 0, this.extraValuesNames.length);
        } else {
            data.extraValuesNames = null;
        }
        data.broken = this.broken;
        data.dataStatus = this.dataStatus;
        return data;
    }

    @Override
    public Envelope getDefaultEnvelope() {
        if (this.envelope == null && this.getDefaultGeometry() != null) {
            this.envelope = this.getDefaultGeometry().getEnvelope();
        }
        return this.envelope;
    }

    @Override
    public Geometry getDefaultGeometry() {
        return this.defaultGeometry;
    }

    @Override
    public Time getDefaultTime() {
        int index = this.featureType.getDefaultTimeAttributeIndex();
        Object value = this.get(index);
        if (!(value instanceof Time)) {
            try {
                value = (Time)ToolsLocator.getDataTypesManager().coerce(68, value);
            }
            catch (CoercionException coercionException) {
                // empty catch block
            }
        }
        return (Time)value;
    }

    @Override
    public void setDefaultEnvelope(Envelope envelope) {
        this.envelope = envelope;
    }

    @Override
    public void setDefaultGeometry(Geometry geom) {
        int i = this.featureType.getDefaultGeometryAttributeIndex();
        this.set(i, (Object)geom);
    }

    @Override
    public void setDefaultTime(Time time) {
        int i = this.featureType.getDefaultTimeAttributeIndex();
        this.set(i, (Object)time);
    }

    @Override
    public boolean isNull(int i) {
        return this.nulls[i];
    }

    @Override
    public boolean isNull(String name) {
        int i = this.featureType.getIndex(name);
        return this.isNull(i);
    }

    @Override
    public Object getOID() {
        return this.oid;
    }

    @Override
    public void setOID(Object oid) {
        this.oid = oid;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    @Override
    public void setExtraValue(int index, Object value) {
        this.extraValues[index] = value;
    }

    @Override
    public Object getExtraValue(int index) {
        if (this.extraValues == null) {
            return null;
        }
        return this.extraValues[index];
    }

    @Override
    public Object getExtraValue(String name) {
        if (this.extraValuesNames == null || this.extraValues == null) {
            return null;
        }
        for (int i = 0; i < this.extraValuesNames.length; ++i) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)this.extraValuesNames[i], (CharSequence)name)) continue;
            return this.extraValues[i];
        }
        return null;
    }

    @Override
    public boolean hasExtraValue(String name) {
        if (this.extraValuesNames == null) {
            return false;
        }
        for (int i = 0; i < this.extraValuesNames.length; ++i) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)this.extraValuesNames[i], (CharSequence)name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setExtraValueNames(String[] extraValueNames) {
        this.extraValuesNames = extraValueNames;
        this.extraValues = new Object[this.extraValuesNames.length];
    }

    @Override
    public boolean isBroken() {
        return this.broken;
    }

    public void setBroken(boolean b) {
        this.broken = b;
        if (b) {
            this.dataStatus = 1;
        }
    }

    public void setDataStatus(int status) {
        this.dataStatus = status;
        if (status == 1) {
            this.broken = true;
        }
    }

    @Override
    public int getDataStatus() {
        return this.dataStatus;
    }
}

