/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.shp;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.io.shp.SHPDriverFunction;
import org.h2gis.utilities.URIUtilities;

public class SHPWrite
extends AbstractFunction
implements ScalarFunction {
    public SHPWrite() {
        this.addProperty("remarks", "Transfer the content of a table into a new shape file\nCALL SHPWRITE('FILENAME', 'TABLE'[,'ENCODING'])");
    }

    public String getJavaStaticMethod() {
        return "exportTable";
    }

    public static void exportTable(Connection connection, String fileName, String tableReference) throws IOException, SQLException {
        SHPWrite.exportTable(connection, fileName, tableReference, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void exportTable(Connection connection, String fileName, String tableReference, String encoding) throws IOException, SQLException {
        String regex = ".*(?i)\\b(select|from)\\b.*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(tableReference);
        SHPDriverFunction shpDriverFunction = new SHPDriverFunction();
        if (matcher.find()) {
            if (!tableReference.startsWith("(") || !tableReference.endsWith(")")) throw new SQLException("The select query must be enclosed in parenthesis: '(SELECT * FROM ORDERS)'.");
            shpDriverFunction.exportResultset(connection, tableReference, URIUtilities.fileFromString((String)fileName), new EmptyProgressVisitor(), encoding);
            return;
        } else {
            shpDriverFunction.exportTable(connection, tableReference, URIUtilities.fileFromString((String)fileName), (ProgressVisitor)new EmptyProgressVisitor(), encoding);
        }
    }
}

