/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.gml2.GMLWriter;
import org.h2gis.api.DeterministicScalarFunction;

public class ST_AsGML
extends DeterministicScalarFunction {
    public ST_AsGML() {
        this.addProperty("remarks", "Store a geometry as a GML representation.\nIt supports OGC GML standard 2.1.2");
    }

    public String getJavaStaticMethod() {
        return "toGML";
    }

    public static String toGML(Geometry geom) {
        if (geom == null) {
            return null;
        }
        int srid = geom.getSRID();
        GMLWriter gmlw = new GMLWriter();
        if (srid != -1 || srid != 0) {
            gmlw.setSrsName("EPSG:" + geom.getSRID());
        }
        return gmlw.write(geom);
    }
}

