/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.mysql;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.spatial.GeometrySqlTypeDescriptor;
import org.hibernate.spatial.GeometryType;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.mysql.MySQLGeometryTypeDescriptor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class MySQLSpatialDialect
extends MySQLDialect
implements SpatialDialect {
    public MySQLSpatialDialect() {
        Map<String, StandardSQLFunction> functionsToRegister = this.getFunctionsToRegister();
        Map<String, Integer> columnTypes = this.getColumnTypesToRegister();
        if (null != columnTypes) {
            for (String aKey : columnTypes.keySet()) {
                this.registerColumnType(columnTypes.get(aKey), aKey);
            }
        }
        if (null != functionsToRegister) {
            for (String aKey : functionsToRegister.keySet()) {
                this.registerFunction(aKey, (SQLFunction)functionsToRegister.get(aKey));
            }
        }
    }

    protected Map<String, Integer> getColumnTypesToRegister() {
        HashMap<String, Integer> columnTypes = new HashMap<String, Integer>();
        columnTypes.put("GEOMETRY", 2003);
        return columnTypes;
    }

    protected Map<String, StandardSQLFunction> getFunctionsToRegister() {
        HashMap<String, StandardSQLFunction> functionsToRegister = new HashMap<String, StandardSQLFunction>();
        functionsToRegister.put("dimension", new StandardSQLFunction("dimension", (Type)StandardBasicTypes.INTEGER));
        functionsToRegister.put("geometrytype", new StandardSQLFunction("geometrytype", (Type)StandardBasicTypes.STRING));
        functionsToRegister.put("srid", new StandardSQLFunction("srid", (Type)StandardBasicTypes.INTEGER));
        functionsToRegister.put("envelope", new StandardSQLFunction("envelope", (Type)GeometryType.INSTANCE));
        functionsToRegister.put("astext", new StandardSQLFunction("astext", (Type)StandardBasicTypes.STRING));
        functionsToRegister.put("asbinary", new StandardSQLFunction("asbinary", (Type)StandardBasicTypes.BINARY));
        functionsToRegister.put("isempty", new StandardSQLFunction("isempty", (Type)StandardBasicTypes.BOOLEAN));
        functionsToRegister.put("issimple", new StandardSQLFunction("issimple", (Type)StandardBasicTypes.BOOLEAN));
        functionsToRegister.put("boundary", new StandardSQLFunction("boundary", (Type)GeometryType.INSTANCE));
        functionsToRegister.put("overlaps", new StandardSQLFunction("overlaps", (Type)StandardBasicTypes.BOOLEAN));
        functionsToRegister.put("intersects", new StandardSQLFunction("intersects", (Type)StandardBasicTypes.BOOLEAN));
        functionsToRegister.put("equals", new StandardSQLFunction("equals", (Type)StandardBasicTypes.BOOLEAN));
        functionsToRegister.put("contains", new StandardSQLFunction("contains", (Type)StandardBasicTypes.BOOLEAN));
        functionsToRegister.put("crosses", new StandardSQLFunction("crosses", (Type)StandardBasicTypes.BOOLEAN));
        functionsToRegister.put("disjoint", new StandardSQLFunction("disjoint", (Type)StandardBasicTypes.BOOLEAN));
        functionsToRegister.put("touches", new StandardSQLFunction("touches", (Type)StandardBasicTypes.BOOLEAN));
        functionsToRegister.put("within", new StandardSQLFunction("within", (Type)StandardBasicTypes.BOOLEAN));
        functionsToRegister.put("relate", new StandardSQLFunction("relate", (Type)StandardBasicTypes.BOOLEAN));
        functionsToRegister.put("distance", new StandardSQLFunction("distance", (Type)StandardBasicTypes.DOUBLE));
        functionsToRegister.put("buffer", new StandardSQLFunction("buffer", (Type)GeometryType.INSTANCE));
        functionsToRegister.put("convexhull", new StandardSQLFunction("convexhull", (Type)GeometryType.INSTANCE));
        functionsToRegister.put("difference", new StandardSQLFunction("difference", (Type)GeometryType.INSTANCE));
        functionsToRegister.put("intersection", new StandardSQLFunction("intersection", (Type)GeometryType.INSTANCE));
        functionsToRegister.put("symdifference", new StandardSQLFunction("symdifference", (Type)GeometryType.INSTANCE));
        functionsToRegister.put("geomunion", new StandardSQLFunction("union", (Type)GeometryType.INSTANCE));
        return functionsToRegister;
    }

    public String getTypeName(int code, long length, int precision, int scale) throws HibernateException {
        if (code == 3000) {
            return "GEOMETRY";
        }
        return super.getTypeName(code, length, precision, scale);
    }

    public SqlTypeDescriptor remapSqlTypeDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
        if (sqlTypeDescriptor instanceof GeometrySqlTypeDescriptor) {
            return MySQLGeometryTypeDescriptor.INSTANCE;
        }
        return super.remapSqlTypeDescriptor(sqlTypeDescriptor);
    }

    @Override
    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        switch (spatialRelation) {
            case 4: {
                return " within(" + columnName + ",?)";
            }
            case 6: {
                return " contains(" + columnName + ", ?)";
            }
            case 3: {
                return " crosses(" + columnName + ", ?)";
            }
            case 5: {
                return " overlaps(" + columnName + ", ?)";
            }
            case 1: {
                return " disjoint(" + columnName + ", ?)";
            }
            case 7: {
                return " intersects(" + columnName + ", ?)";
            }
            case 2: {
                return " touches(" + columnName + ", ?)";
            }
            case 0: {
                return " equals(" + columnName + ", ?)";
            }
        }
        throw new IllegalArgumentException("Spatial relation is not known by this dialect");
    }

    @Override
    public String getSpatialFilterExpression(String columnName) {
        return "MBRIntersects(" + columnName + ", ? ) ";
    }

    @Override
    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        throw new UnsupportedOperationException("Mysql has no spatial aggregate SQL functions.");
    }

    @Override
    public String getDWithinSQL(String columnName) {
        throw new UnsupportedOperationException(String.format("Mysql doesn't support the Dwithin function", new Object[0]));
    }

    @Override
    public String getHavingSridSQL(String columnName) {
        return " (srid(" + columnName + ") = ?) ";
    }

    @Override
    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        String emptyExpr = " IsEmpty(" + columnName + ") ";
        return isEmpty ? emptyExpr : "( NOT " + emptyExpr + ")";
    }

    public String getDbGeometryTypeName() {
        return "GEOMETRY";
    }

    @Override
    public boolean supportsFiltering() {
        return false;
    }

    @Override
    public boolean supports(SpatialFunction function) {
        switch (function) {
            case boundary: 
            case relate: 
            case distance: 
            case buffer: 
            case convexhull: 
            case difference: 
            case symdifference: 
            case intersection: 
            case geomunion: 
            case dwithin: 
            case transform: {
                return false;
            }
        }
        return true;
    }
}

