/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import org.hibernate.HibernateException;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.spatial.dialect.oracle.ConnectionFinder;
import org.hibernate.spatial.dialect.oracle.ElemInfo;
import org.hibernate.spatial.dialect.oracle.Ordinates;
import org.hibernate.spatial.dialect.oracle.SDOGeometry;
import org.hibernate.spatial.dialect.oracle.SQLTypeFactory;
import org.hibernate.spatial.helper.FinderException;

public class OracleJDBCTypeFactory
implements SQLTypeFactory {
    private final Class<?> datumClass;
    private final Class<?> numberClass;
    private final Class<?> arrayClass;
    private final Class<?> structClass;
    private final Class<?> arrayDescriptorClass;
    private final Class<?> structDescriptorClass;
    private final Method structDescriptorCreator;
    private final Method arrayDescriptorCreator;
    private final Constructor<?> numberConstructor;
    private final Constructor<?> arrayConstructor;
    private final Constructor<?> structConstructor;
    private final ConnectionFinder connectionFinder;

    public OracleJDBCTypeFactory(ConnectionFinder connectionFinder) {
        if (connectionFinder == null) {
            throw new HibernateException("ConnectionFinder cannot be null");
        }
        this.connectionFinder = connectionFinder;
        Object[] obj = this.findDescriptorCreator("oracle.sql.StructDescriptor");
        this.structDescriptorClass = (Class)obj[0];
        this.structDescriptorCreator = (Method)obj[1];
        obj = this.findDescriptorCreator("oracle.sql.ArrayDescriptor");
        this.arrayDescriptorClass = (Class)obj[0];
        this.arrayDescriptorCreator = (Method)obj[1];
        this.datumClass = this.findClass("oracle.sql.Datum");
        this.numberClass = this.findClass("oracle.sql.NUMBER");
        this.arrayClass = this.findClass("oracle.sql.ARRAY");
        this.structClass = this.findClass("oracle.sql.STRUCT");
        this.numberConstructor = this.findConstructor(this.numberClass, Integer.TYPE);
        this.arrayConstructor = this.findConstructor(this.arrayClass, this.arrayDescriptorClass, Connection.class, Object.class);
        this.structConstructor = this.findConstructor(this.structClass, this.structDescriptorClass, Connection.class, Object[].class);
    }

    private Constructor<?> findConstructor(Class clazz, Class<?> ... arguments) {
        try {
            return clazz.getConstructor(arguments);
        }
        catch (NoSuchMethodException e) {
            throw new HibernateException("Error finding constructor for oracle.sql type.", (Throwable)e);
        }
    }

    private Class<?> findClass(String name) {
        try {
            return ReflectHelper.classForName((String)name);
        }
        catch (ClassNotFoundException e) {
            throw new HibernateException("Class 'oracle.sql.Datum' not found on class path");
        }
    }

    private Object[] findDescriptorCreator(String className) {
        try {
            Class clazz = ReflectHelper.classForName((String)className);
            Method m = clazz.getMethod("createDescriptor", String.class, Connection.class);
            return new Object[]{clazz, m};
        }
        catch (ClassNotFoundException e) {
            throw new HibernateException("Class 'StructDescriptor' not found on classpath");
        }
        catch (NoSuchMethodException e) {
            throw new HibernateException("Class 'StructDescriptor' has no method 'createDescriptor(String,Connection)'");
        }
    }

    @Override
    public Struct createStruct(SDOGeometry geom, Connection conn) throws SQLException {
        Connection oracleConnection = null;
        try {
            oracleConnection = (Connection)this.connectionFinder.find(conn);
        }
        catch (FinderException e) {
            throw new HibernateException("Problem finding Oracle Connection", (Throwable)e);
        }
        Object structDescriptor = this.createStructDescriptor(SDOGeometry.getTypeName(), oracleConnection);
        Object[] attributes = this.createDatumArray(5);
        attributes[0] = this.createNumber(geom.getGType().intValue());
        attributes[1] = geom.getSRID() > 0 ? this.createNumber(geom.getSRID()) : null;
        attributes[3] = this.createElemInfoArray(geom.getInfo(), oracleConnection);
        attributes[4] = this.createOrdinatesArray(geom.getOrdinates(), oracleConnection);
        return this.createStruct(structDescriptor, oracleConnection, attributes);
    }

    @Override
    public java.sql.Array createElemInfoArray(ElemInfo elemInfo, Connection conn) {
        Object arrayDescriptor = this.createArrayDescriptor("MDSYS.SDO_ELEM_INFO_ARRAY", conn);
        return this.createArray(arrayDescriptor, conn, elemInfo.getElements());
    }

    @Override
    public java.sql.Array createOrdinatesArray(Ordinates ordinates, Connection conn) throws SQLException {
        Object arrayDescriptor = this.createArrayDescriptor("MDSYS.SDO_ORDINATE_ARRAY", conn);
        return this.createArray(arrayDescriptor, conn, ordinates.getOrdinateArray());
    }

    private java.sql.Array createArray(Object descriptor, Connection conn, Object[] data) {
        try {
            return (java.sql.Array)this.arrayConstructor.newInstance(descriptor, conn, data);
        }
        catch (InstantiationException e) {
            throw new HibernateException("Problem creating ARRAY.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new HibernateException("Problem creating ARRAY.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new HibernateException("Problem creating ARRAY.", (Throwable)e);
        }
    }

    private Struct createStruct(Object descriptor, Connection conn, Object[] attributes) {
        try {
            return (Struct)this.structConstructor.newInstance(descriptor, conn, attributes);
        }
        catch (InstantiationException e) {
            throw new HibernateException("Problem creating STRUCT.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new HibernateException("Problem creating STRUCT.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new HibernateException("Problem creating STRUCT.", (Throwable)e);
        }
    }

    private Object createStructDescriptor(String sqlType, Connection conn) {
        try {
            return this.structDescriptorCreator.invoke(null, sqlType, conn);
        }
        catch (IllegalAccessException e) {
            throw new HibernateException("Error creating oracle STRUCT", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new HibernateException("Error creating oracle STRUCT", (Throwable)e);
        }
    }

    private Object createArrayDescriptor(String name, Connection conn) {
        try {
            return this.arrayDescriptorCreator.invoke(null, name, conn);
        }
        catch (IllegalAccessException e) {
            throw new HibernateException("Error creating oracle ARRAY", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new HibernateException("Error creating oracle ARRAY", (Throwable)e);
        }
    }

    private Object[] createDatumArray(int size) {
        return (Object[])Array.newInstance(this.datumClass, size);
    }

    private Object createNumber(int obj) {
        try {
            return this.numberConstructor.newInstance(obj);
        }
        catch (InvocationTargetException e) {
            throw new HibernateException("Error creating oracle NUMBER", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new HibernateException("Error creating oracle NUMBER", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new HibernateException("Error creating oracle NUMBER", (Throwable)e);
        }
    }
}

