/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.type.Type;

class SDOObjectMethod
implements SQLFunction {
    private final Type type;
    private final String name;

    public SDOObjectMethod(String name, Type type) {
        this.type = type;
        this.name = name;
    }

    public Type getReturnType(Type columnType, Mapping mapping) throws QueryException {
        return this.type == null ? columnType : this.type;
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public String render(Type firstArgumentType, List args, SessionFactoryImplementor factory) throws QueryException {
        StringBuffer buf = new StringBuffer();
        if (args.isEmpty()) {
            throw new QueryException("First Argument in arglist must be object to which method is applied");
        }
        buf.append(args.get(0)).append(".").append(this.name).append('(');
        for (int i = 1; i < args.size(); ++i) {
            buf.append(args.get(i));
            if (i >= args.size() - 1) continue;
            buf.append(", ");
        }
        return buf.append(')').toString();
    }
}

