/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver.convertors;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.spatial.dialect.sqlserver.convertors.AbstractDecoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.Decoders;
import org.hibernate.spatial.dialect.sqlserver.convertors.OpenGisType;
import org.hibernate.spatial.dialect.sqlserver.convertors.SqlServerGeometry;
import org.hibernate.spatial.jts.mgeom.MGeometryFactory;

abstract class AbstractGeometryCollectionDecoder<T extends GeometryCollection>
extends AbstractDecoder<T> {
    public AbstractGeometryCollectionDecoder(MGeometryFactory factory) {
        super(factory);
    }

    @Override
    protected OpenGisType getOpenGisType() {
        return OpenGisType.GEOMETRYCOLLECTION;
    }

    @Override
    protected T createNullGeometry() {
        return this.createGeometry((List<Geometry>)null, false);
    }

    @Override
    protected T createGeometry(SqlServerGeometry nativeGeom) {
        return this.createGeometry(nativeGeom, 0);
    }

    @Override
    protected T createGeometry(SqlServerGeometry nativeGeom, int shapeIndex) {
        int startChildIdx = shapeIndex + 1;
        ArrayList<Geometry> geometries = new ArrayList<Geometry>(nativeGeom.getNumShapes());
        for (int childIdx = startChildIdx; childIdx < nativeGeom.getNumShapes(); ++childIdx) {
            if (!nativeGeom.isParentShapeOf(shapeIndex, childIdx)) continue;
            AbstractDecoder decoder = (AbstractDecoder)Decoders.decoderFor(nativeGeom.getOpenGisTypeOfShape(childIdx));
            Object geometry = decoder.createGeometry(nativeGeom, childIdx);
            geometries.add((Geometry)geometry);
        }
        return this.createGeometry(geometries, nativeGeom.hasMValues());
    }

    protected abstract T createGeometry(List<Geometry> var1, boolean var2);
}

